/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket.core;

import cool.scx.common.util.StringUtils;
import cool.scx.socket.core.ScxSocketOptions;
import cool.scx.socket.core.ScxSocketStatus;
import cool.scx.socket.event.EventManager;
import cool.scx.socket.frame.FrameCreator;
import cool.scx.socket.frame.ScxSocketFrame;
import cool.scx.socket.helper.EasyUseHelper;
import cool.scx.socket.request.RequestManager;
import cool.scx.socket.request.ScxSocketRequest;
import cool.scx.socket.sender.SendOptions;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;
import java.util.function.Consumer;

public class ScxSocket
extends EventManager
implements EasyUseHelper {
    public final String clientID;
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    protected final ScxSocketOptions options;
    protected final ScxSocketStatus status;
    public WebSocketBase webSocket;

    public ScxSocket(ScxSocketOptions options, String clientID) {
        this.options = options;
        this.clientID = clientID;
        this.status = new ScxSocketStatus(options);
    }

    public ScxSocket(ScxSocket scxSocket) {
        super(scxSocket);
        this.options = scxSocket.options;
        this.clientID = scxSocket.clientID;
        this.status = scxSocket.status;
    }

    @Override
    public void send(ScxSocketFrame socketFrame, SendOptions options) {
        this.status.frameSender.send(socketFrame, options, this);
    }

    protected void doMessage(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        if (StringUtils.isBlank((String)socketFrame.event_name)) {
            this.callOnMessageWithCheckDuplicateAsync(socketFrame);
        } else {
            this.callOnEventWithCheckDuplicateAsync(socketFrame);
        }
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230\u6d88\u606f : {1}", this.clientID, socketFrame.toJson());
        }
    }

    protected void doResponse(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        this.requestManager().successAsync(socketFrame);
    }

    protected void doAck(ScxSocketFrame ackFrame) {
        this.status.frameSender.clearSendTask(ackFrame);
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 ACK : {1}", this.clientID, ackFrame.toJson());
        }
    }

    protected void doClose(Void v) {
        this.close();
        this._callOnClose(v);
    }

    protected void doError(Throwable e) {
        this.close();
        this._callOnError(e);
    }

    protected void start(WebSocketBase webSocket) {
        this.close();
        this.bind(webSocket);
        this.status.frameSender.startAllSendTask(this);
        this.status.duplicateFrameChecker.startAllClearTask();
    }

    public void close() {
        this.closeWebSocket();
        this.status.frameSender.cancelAllResendTask();
        this.status.duplicateFrameChecker.cancelAllClearTask();
    }

    public String clientID() {
        return this.clientID;
    }

    @Override
    public void sendResponse(long ack_id, String responseData) {
        SendOptions sendOptions = new SendOptions();
        this.send(this.status.frameCreator.createResponseFrame(ack_id, responseData, sendOptions), sendOptions);
    }

    @Override
    protected ScxSocketRequest createRequest(long ack_id) {
        return new ScxSocketRequest(this, ack_id);
    }

    protected void sendAck(long ack_id) {
        ScxSocketFrame ackFrame = FrameCreator.createAckFrame(ack_id);
        Future sendAckFuture = this.webSocket.writeTextMessage(ackFrame.toJson());
        sendAckFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u6210\u529f : {1}", this.clientID, ackFrame.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u5931\u8d25 : {1}", this.clientID, ackFrame.toJson(), c);
            }
        });
    }

    protected void bind(WebSocketBase webSocket) {
        this.webSocket = webSocket;
        this.webSocket.textMessageHandler(t -> this.doSocketFrame(ScxSocketFrame.fromJson(t)));
        this.webSocket.closeHandler(this::doClose);
        this.webSocket.exceptionHandler(this::doError);
    }

    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        switch (socketFrame.type) {
            case 0: {
                this.doMessage(socketFrame);
                break;
            }
            case 1: {
                this.doResponse(socketFrame);
                break;
            }
            case 2: {
                this.doAck(socketFrame);
            }
        }
    }

    protected void closeWebSocket() {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.close().onSuccess(c -> {});
        }
    }

    public boolean isClosed() {
        return this.webSocket == null || this.webSocket.isClosed();
    }

    @Override
    public final void onClose(Consumer<Void> onClose) {
        super.onClose(onClose);
        if (this.webSocket != null) {
            this.webSocket.closeHandler(this::doClose);
        }
    }

    @Override
    public final void onError(Consumer<Throwable> onError) {
        super.onError(onError);
        if (this.webSocket != null) {
            this.webSocket.exceptionHandler(this::doError);
        }
    }

    private void callOnMessageWithCheckDuplicateAsync(ScxSocketFrame socketFrame) {
        if (this.status.duplicateFrameChecker.check(socketFrame)) {
            this._callOnMessageAsync(socketFrame.payload);
        }
    }

    private void callOnEventWithCheckDuplicateAsync(ScxSocketFrame socketFrame) {
        if (this.status.duplicateFrameChecker.check(socketFrame)) {
            this._callOnEventAsync(socketFrame);
        }
    }

    @Override
    public FrameCreator frameCreator() {
        return this.status.frameCreator;
    }

    @Override
    public RequestManager requestManager() {
        return this.status.requestManager;
    }
}

