/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket.frame;

import cool.scx.socket.frame.ScxSocketFrame;
import cool.scx.socket.sender.SendOptions;
import java.util.concurrent.atomic.AtomicLong;

public final class FrameCreator {
    public static final ScxSocketFrame PING_FRAME = FrameCreator.createPingFrame();
    public static final ScxSocketFrame PONG_FRAME = FrameCreator.createPongFrame();
    private final AtomicLong seqID = new AtomicLong(0L);

    private static ScxSocketFrame createPingFrame() {
        ScxSocketFrame pingFrame = new ScxSocketFrame();
        pingFrame.type = (byte)3;
        return pingFrame;
    }

    private static ScxSocketFrame createPongFrame() {
        ScxSocketFrame pongFrame = new ScxSocketFrame();
        pongFrame.type = (byte)4;
        return pongFrame;
    }

    public static ScxSocketFrame createAckFrame(long ack_id) {
        ScxSocketFrame ackFrame = new ScxSocketFrame();
        ackFrame.type = (byte)2;
        ackFrame.ack_id = ack_id;
        return ackFrame;
    }

    public static ScxSocketFrame createAckFrame(long ack_id, String payload) {
        ScxSocketFrame ackFrame = FrameCreator.createAckFrame(ack_id);
        ackFrame.payload = payload;
        return ackFrame;
    }

    private ScxSocketFrame createBaseFrame(String content, SendOptions options) {
        ScxSocketFrame baseFrame = new ScxSocketFrame();
        baseFrame.seq_id = this.seqID.getAndIncrement();
        baseFrame.now = System.currentTimeMillis();
        baseFrame.need_ack = options.getNeedAck();
        baseFrame.payload = content;
        return baseFrame;
    }

    public ScxSocketFrame createMessageFrame(String content, SendOptions options) {
        ScxSocketFrame messageFrame = this.createBaseFrame(content, options);
        messageFrame.type = 0;
        return messageFrame;
    }

    public ScxSocketFrame createEventFrame(String eventName, String payload, SendOptions options) {
        ScxSocketFrame eventFrame = this.createMessageFrame(payload, options);
        eventFrame.event_name = eventName;
        return eventFrame;
    }

    public ScxSocketFrame createRequestFrame(String eventName, String payload, SendOptions options) {
        ScxSocketFrame requestFrame = this.createEventFrame(eventName, payload, options);
        requestFrame.need_response = true;
        return requestFrame;
    }

    public ScxSocketFrame createResponseFrame(long ack_id, String payload, SendOptions options) {
        ScxSocketFrame responseFrame = this.createBaseFrame(payload, options);
        responseFrame.type = 1;
        responseFrame.ack_id = ack_id;
        return responseFrame;
    }
}

