/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.socket.frame.FrameCreator;
import cool.scx.socket.frame.ScxSocketFrame;
import cool.scx.socket.helper.Helper;
import cool.scx.socket.request.RequestManager;
import cool.scx.socket.request.RequestOptions;
import cool.scx.socket.request.ScxSocketRequest;
import cool.scx.socket.sender.SendOptions;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface EasyUseHelper {
    public static final SendOptions DEFAULT_SEND_OPTIONS = new SendOptions();
    public static final RequestOptions DEFAULT_REQUEST_OPTIONS = new RequestOptions();

    public FrameCreator frameCreator();

    public RequestManager requestManager();

    public void send(ScxSocketFrame var1, SendOptions var2);

    default public void send(String content) {
        this.send(this.frameCreator().createMessageFrame(content, DEFAULT_SEND_OPTIONS), DEFAULT_SEND_OPTIONS);
    }

    default public void send(String content, SendOptions options) {
        this.send(this.frameCreator().createMessageFrame(content, options), options);
    }

    default public void sendEvent(String eventName, String data) {
        this.send(this.frameCreator().createEventFrame(eventName, data, DEFAULT_SEND_OPTIONS), DEFAULT_SEND_OPTIONS);
    }

    default public void sendEvent(String eventName, String data, SendOptions options) {
        this.send(this.frameCreator().createEventFrame(eventName, data, options), options);
    }

    default public void sendEvent(String eventName, String data, BiConsumer<String, Throwable> responseCallback) {
        ScxSocketFrame eventFrame = this.frameCreator().createRequestFrame(eventName, data, DEFAULT_REQUEST_OPTIONS);
        this.requestManager().setResponseCallback(eventFrame, responseCallback, DEFAULT_REQUEST_OPTIONS);
        this.send(eventFrame, (SendOptions)DEFAULT_REQUEST_OPTIONS);
    }

    default public void sendEvent(String eventName, String data, BiConsumer<String, Throwable> responseCallback, RequestOptions options) {
        ScxSocketFrame eventFrame = this.frameCreator().createRequestFrame(eventName, data, options);
        this.requestManager().setResponseCallback(eventFrame, responseCallback, options);
        this.send(eventFrame, (SendOptions)options);
    }

    public void onEvent(String var1, Consumer<String> var2);

    public void onEvent(String var1, Function<String, String> var2);

    public void onEvent(String var1, BiConsumer<String, ScxSocketRequest> var2);

    default public void send(Object data) {
        this.send(Helper.toJson(data));
    }

    default public void send(Object data, SendOptions options) {
        this.send(Helper.toJson(data), options);
    }

    default public void sendEvent(String eventName, Object data) {
        this.sendEvent(eventName, Helper.toJson(data));
    }

    default public void sendEvent(String eventName, Object data, SendOptions options) {
        this.sendEvent(eventName, Helper.toJson(data), options);
    }

    default public void sendEvent(String eventName, Object data, BiConsumer<String, Throwable> responseCallback) {
        this.sendEvent(eventName, Helper.toJson(data), responseCallback);
    }

    default public void sendEvent(String eventName, Object data, BiConsumer<String, Throwable> responseCallback, RequestOptions options) {
        this.sendEvent(eventName, Helper.toJson(data), responseCallback, options);
    }

    default public <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, Class<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e));
    }

    default public <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, RequestOptions options, Class<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e), options);
    }

    default public <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, TypeReference<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e));
    }

    default public <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, RequestOptions options, TypeReference<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e), options);
    }

    default public <T> void onEvent(String eventName, Consumer<T> onEvent, Class<T> tClass) {
        this.onEvent(eventName, (String s) -> onEvent.accept(Helper.fromJson(s, tClass)));
    }

    default public <T> void onEvent(String eventName, Function<T, ?> onEvent, Class<T> tClass) {
        this.onEvent(eventName, (String s) -> {
            Object data = onEvent.apply(Helper.fromJson(s, tClass));
            if (data instanceof String) {
                String str = (String)data;
                return str;
            }
            return Helper.toJson(data);
        });
    }

    default public <T> void onEvent(String eventName, Consumer<T> onEvent, TypeReference<T> tClass) {
        this.onEvent(eventName, (String s) -> onEvent.accept(Helper.fromJson(s, tClass)));
    }

    default public <T> void onEvent(String eventName, Function<T, ?> onEvent, TypeReference<T> tClass) {
        this.onEvent(eventName, (String s) -> {
            Object data = onEvent.apply(Helper.fromJson(s, tClass));
            if (data instanceof String) {
                String str = (String)data;
                return str;
            }
            return Helper.toJson(data);
        });
    }

    default public <T> void onEvent(String eventName, BiConsumer<T, TypeRequest> onEvent, Class<T> tClass) {
        this.onEvent(eventName, (String s, ScxSocketRequest r) -> onEvent.accept(Helper.fromJson(s, tClass), new TypeRequest((ScxSocketRequest)r)));
    }

    default public <T> void onEvent(String eventName, BiConsumer<T, TypeRequest> onEvent, TypeReference<T> tClass) {
        this.onEvent(eventName, (String s, ScxSocketRequest r) -> onEvent.accept(Helper.fromJson(s, tClass), new TypeRequest((ScxSocketRequest)r)));
    }

    public static class TypeRequest {
        private final ScxSocketRequest request;

        public TypeRequest(ScxSocketRequest r) {
            this.request = r;
        }

        public void response(String payload) {
            this.request.response(payload);
        }

        public void response(Object payload) {
            this.request.response(Helper.toJson(payload));
        }
    }
}

