/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket.ping_pong;

import cool.scx.socket.core.ScxSocket;
import cool.scx.socket.frame.FrameCreator;
import cool.scx.socket.frame.ScxSocketFrame;
import cool.scx.socket.helper.Helper;
import cool.scx.socket.ping_pong.PingPongOptions;
import io.netty.util.Timeout;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;

public abstract class PingPongManager
extends ScxSocket {
    private final PingPongOptions pingPongOptions;
    private Timeout ping;
    private Timeout pingTimeout;

    public PingPongManager(PingPongOptions options, String clientID) {
        super(options, clientID);
        this.pingPongOptions = options;
    }

    public PingPongManager(PingPongManager pingPongManager) {
        super(pingPongManager);
        this.pingPongOptions = pingPongManager.pingPongOptions;
    }

    private void startPingTimeout() {
        this.cancelPingTimeout();
        this.pingTimeout = Helper.setTimeout(this::doPingTimeout, this.pingPongOptions.getPingTimeout() + this.pingPongOptions.getPingInterval());
    }

    private void cancelPingTimeout() {
        if (this.pingTimeout != null) {
            this.pingTimeout.cancel();
            this.pingTimeout = null;
        }
    }

    protected void startPing() {
        this.cancelPing();
        this.ping = Helper.setTimeout(() -> {
            this.sendPing();
            this.startPing();
        }, this.pingPongOptions.getPingInterval());
    }

    private void cancelPing() {
        if (this.ping != null) {
            this.ping.cancel();
            this.ping = null;
        }
    }

    @Override
    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        this.startPing();
        this.startPingTimeout();
        switch (socketFrame.type) {
            case 3: {
                this.doPing(socketFrame);
                break;
            }
            case 4: {
                this.doPong(socketFrame);
                break;
            }
            default: {
                super.doSocketFrame(socketFrame);
            }
        }
    }

    @Override
    protected void start(WebSocketBase webSocket) {
        super.start(webSocket);
        this.startPing();
        this.startPingTimeout();
    }

    @Override
    public void close() {
        super.close();
        this.cancelPing();
        this.cancelPingTimeout();
    }

    private void sendPing() {
        Future sendPingFuture = this.webSocket.writeTextMessage(FrameCreator.PING_FRAME.toJson());
        sendPingFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PING \u6210\u529f : {1}", this.clientID, FrameCreator.PONG_FRAME.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PING \u5931\u8d25: {1}", FrameCreator.PONG_FRAME.toJson(), c);
            }
        });
    }

    private void sendPong() {
        Future sendPongFuture = this.webSocket.writeTextMessage(FrameCreator.PONG_FRAME.toJson());
        sendPongFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PONG \u6210\u529f : {1}", this.clientID, FrameCreator.PONG_FRAME.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PONG \u5931\u8d25 : {1}", this.clientID, FrameCreator.PONG_FRAME.toJson(), c);
            }
        });
    }

    private void doPing(ScxSocketFrame socketFrame) {
        this.sendPong();
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 PING : {1}", this.clientID, socketFrame.toJson());
        }
    }

    private void doPong(ScxSocketFrame socketFrame) {
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 PONG : {1}", this.clientID, socketFrame.toJson());
        }
    }

    protected abstract void doPingTimeout();
}

