/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.common.util.StringUtils;
import cool.scx.socket.EventHandler;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.ScxSocketRequest;
import cool.scx.socket.ScxSocketStatus;
import cool.scx.socket.SendOptions;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class ScxSocket {
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    final WebSocketBase webSocket;
    final String clientID;
    final ScxSocketOptions options;
    final ScxSocketStatus status;
    private final ConcurrentMap<String, EventHandler> eventHandlerMap;
    private Consumer<String> onMessage;
    private Consumer<Void> onClose;
    private Consumer<Throwable> onError;

    ScxSocket(WebSocketBase webSocket, String clientID, ScxSocketOptions options, ScxSocketStatus status) {
        this.webSocket = webSocket;
        this.clientID = clientID;
        this.options = options;
        this.status = status;
        this.eventHandlerMap = new ConcurrentHashMap<String, EventHandler>();
        this.onMessage = null;
        this.onClose = null;
        this.onError = null;
    }

    ScxSocket(WebSocketBase webSocket, String clientID, ScxSocketOptions options) {
        this(webSocket, clientID, options, new ScxSocketStatus(options));
    }

    public final String clientID() {
        return this.clientID;
    }

    public final void send(ScxSocketFrame socketFrame, SendOptions options) {
        this.status.frameSender.send(socketFrame, options, this);
    }

    public final void sendResponse(long ack_id, String responseData) {
        SendOptions sendOptions = new SendOptions();
        ScxSocketFrame responseFrame = this.status.frameCreator.createResponseFrame(ack_id, responseData, sendOptions);
        this.send(responseFrame, sendOptions);
    }

    private void sendAck(long ack_id) {
        ScxSocketFrame ackFrame = this.status.frameCreator.createAckFrame(ack_id);
        Future sendAckFuture = this.webSocket.writeTextMessage(ackFrame.toJson());
        sendAckFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u6210\u529f : {1}", this.clientID, ackFrame.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u5931\u8d25 : {1}", this.clientID, ackFrame.toJson(), c);
            }
        });
    }

    public final void onMessage(Consumer<String> onMessage) {
        this.onMessage = onMessage;
    }

    public final void onClose(Consumer<Void> onClose) {
        this.onClose = onClose;
        this.webSocket.closeHandler(this::doClose);
    }

    public final void onError(Consumer<Throwable> onError) {
        this.onError = onError;
        this.webSocket.exceptionHandler(this::doError);
    }

    public final void onEvent(String eventName, Consumer<String> onEvent) {
        this.eventHandlerMap.put(eventName, new EventHandler(onEvent));
    }

    public final void onEvent(String eventName, Function<String, String> onEvent) {
        this.eventHandlerMap.put(eventName, new EventHandler(onEvent));
    }

    public final void onEvent(String eventName, BiConsumer<String, ScxSocketRequest> onEvent) {
        this.eventHandlerMap.put(eventName, new EventHandler(onEvent));
    }

    public final void removeEvent(String eventName) {
        this.eventHandlerMap.remove(eventName);
    }

    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        switch (socketFrame.type) {
            case 0: {
                this.doMessage(socketFrame);
                break;
            }
            case 1: {
                this.doResponse(socketFrame);
                break;
            }
            case 2: {
                this.doAck(socketFrame);
            }
        }
    }

    private void doMessage(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        if (StringUtils.isBlank((String)socketFrame.event_name)) {
            this.callOnMessageWithCheckDuplicate(socketFrame);
        } else {
            this.callOnEventWithCheckDuplicate(socketFrame);
        }
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230\u6d88\u606f : {1}", this.clientID, socketFrame.toJson());
        }
    }

    private void doResponse(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        this.status.requestManager.success(socketFrame);
    }

    private void doAck(ScxSocketFrame ackFrame) {
        this.status.frameSender.clearSendTask(ackFrame);
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 ACK : {1}", this.clientID, ackFrame.toJson());
        }
    }

    protected void doClose(Void v) {
        this.close();
        this._callOnClose(v);
    }

    protected void doError(Throwable e) {
        this.close();
        this._callOnError(e);
    }

    private void bind() {
        this.webSocket.textMessageHandler(t -> this.doSocketFrame(ScxSocketFrame.fromJson(t)));
        this.webSocket.closeHandler(this::doClose);
        this.webSocket.exceptionHandler(this::doError);
    }

    protected void start() {
        this.bind();
        this.status.frameSender.startAllSendTask(this);
        this.status.duplicateFrameChecker.startAllClearTask();
    }

    public void close() {
        this.closeWebSocket();
        this.status.frameSender.cancelAllResendTask();
        this.status.duplicateFrameChecker.cancelAllClearTask();
    }

    protected void closeWebSocket() {
        if (!this.webSocket.isClosed()) {
            Future closeFuture = this.webSocket.close();
            closeFuture.onSuccess(c -> {
                if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                    this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u5173\u95ed\u6210\u529f", this.clientID);
                }
            }).onFailure(e -> {
                if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                    this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u5173\u95ed\u5931\u8d25", this.clientID, e);
                }
            });
        }
    }

    public boolean isClosed() {
        return this.webSocket.isClosed();
    }

    private void callOnMessageWithCheckDuplicate(ScxSocketFrame socketFrame) {
        if (this.status.duplicateFrameChecker.check(socketFrame)) {
            this._callOnMessage(socketFrame.payload);
        }
    }

    private void callOnEventWithCheckDuplicate(ScxSocketFrame socketFrame) {
        if (this.status.duplicateFrameChecker.check(socketFrame)) {
            this._callOnEvent(socketFrame);
        }
    }

    private void _callOnMessage(String message) {
        if (this.onMessage != null) {
            Thread.ofVirtual().name("scx-socket-call-on-message").start(() -> this.onMessage.accept(message));
        }
    }

    private void _callOnClose(Void v) {
        if (this.onClose != null) {
            Thread.ofVirtual().name("scx-socket-call-on-close").start(() -> this.onClose.accept(v));
        }
    }

    private void _callOnError(Throwable e) {
        if (this.onError != null) {
            Thread.ofVirtual().name("scx-socket-call-on-error").start(() -> this.onError.accept(e));
        }
    }

    private void _callOnEvent(ScxSocketFrame socketFrame) {
        EventHandler eventHandler = (EventHandler)this.eventHandlerMap.get(socketFrame.event_name);
        if (eventHandler != null) {
            Thread.ofVirtual().name("scx-socket-call-on-event").start(() -> {
                switch (eventHandler.type) {
                    case 0: {
                        this._callOnEvent0(eventHandler.event0(), socketFrame);
                        break;
                    }
                    case 1: {
                        this._callOnEvent1(eventHandler.event1(), socketFrame);
                        break;
                    }
                    case 2: {
                        this._callOnEvent2(eventHandler.event2(), socketFrame);
                    }
                }
            });
        }
    }

    private void _callOnEvent0(Consumer<String> event0, ScxSocketFrame socketFrame) {
        event0.accept(socketFrame.payload);
        if (socketFrame.need_response) {
            this.sendResponse(socketFrame.seq_id, null);
        }
    }

    private void _callOnEvent1(Function<String, String> event1, ScxSocketFrame socketFrame) {
        String responseData = event1.apply(socketFrame.payload);
        if (socketFrame.need_response) {
            this.sendResponse(socketFrame.seq_id, responseData);
        }
    }

    private void _callOnEvent2(BiConsumer<String, ScxSocketRequest> event2, ScxSocketFrame socketFrame) {
        if (socketFrame.need_response) {
            ScxSocketRequest scxSocketRequest = new ScxSocketRequest(this, socketFrame.seq_id);
            event2.accept(socketFrame.payload, scxSocketRequest);
        } else {
            event2.accept(socketFrame.payload, null);
        }
    }
}

