/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.Helper;
import cool.scx.socket.ScxServerSocket;
import cool.scx.socket.ScxSocketServerOptions;
import io.vertx.core.http.ServerWebSocket;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public final class ScxSocketServer {
    final ConcurrentMap<String, ScxServerSocket> serverSockets;
    final ScxSocketServerOptions options;
    private Consumer<ScxServerSocket> onConnect;

    public ScxSocketServer() {
        this(new ScxSocketServerOptions());
    }

    public ScxSocketServer(ScxSocketServerOptions options) {
        this.options = options;
        this.serverSockets = new ConcurrentHashMap<String, ScxServerSocket>();
    }

    public void onConnect(Consumer<ScxServerSocket> onConnect) {
        this.onConnect = onConnect;
    }

    private void _callOnConnect(ScxServerSocket serverSocket) {
        if (this.onConnect != null) {
            Thread.ofVirtual().name("scx-socket-server-call-on-connect").start(() -> this.onConnect.accept(serverSocket));
        }
    }

    public void call(ServerWebSocket serverWebSocket) {
        String clientID = Helper.getClientID(serverWebSocket);
        if (clientID == null) {
            serverWebSocket.reject(400);
            return;
        }
        ScxServerSocket serverSocket = this.serverSockets.compute(clientID, (k, old) -> {
            if (old == null) {
                return new ScxServerSocket(serverWebSocket, clientID, this);
            }
            old.close();
            return new ScxServerSocket(serverWebSocket, clientID, this, old.status);
        });
        serverSocket.start();
        this._callOnConnect(serverSocket);
    }

    public ScxServerSocket getServerSocket(String clientID) {
        return (ScxServerSocket)this.serverSockets.get(clientID);
    }

    public Collection<ScxServerSocket> getServerSockets() {
        return this.serverSockets.values();
    }
}

