/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.common.util.SingleListenerFuture;
import cool.scx.socket.FrameSender;
import cool.scx.socket.Helper;
import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.SendOptions;
import io.netty.util.Timeout;
import java.util.concurrent.atomic.AtomicInteger;

final class SendTask {
    private static final System.Logger logger = System.getLogger(SendTask.class.getName());
    private final ScxSocketFrame socketFrame;
    private final SendOptions options;
    private final AtomicInteger sendTimes;
    private final FrameSender sender;
    private Timeout resendTask;
    private SingleListenerFuture<Void> sendFuture;

    public SendTask(ScxSocketFrame socketFrame, SendOptions options, FrameSender sender) {
        this.socketFrame = socketFrame;
        this.options = options;
        this.sendTimes = new AtomicInteger(0);
        this.sender = sender;
    }

    public synchronized void start(ScxSocket scxSocket) {
        if (scxSocket.isClosed()) {
            return;
        }
        if (this.sendFuture != null && !this.sendFuture.isComplete()) {
            return;
        }
        if (this.sendTimes.get() > this.options.getMaxResendTimes()) {
            if (this.options.getGiveUpIfReachMaxResendTimes()) {
                this.clear();
            }
            return;
        }
        this.sendFuture = new SingleListenerFuture(scxSocket.webSocket.writeTextMessage(this.socketFrame.toJson()));
        this.sendFuture.onSuccess(webSocket -> {
            int currentSendTime = this.sendTimes.getAndIncrement();
            if (this.options.getNeedAck()) {
                long resendDelayed = Math.max(Helper.getDelayed(currentSendTime), this.options.getMaxResendDelayed());
                this.resendTask = Helper.setTimeout(() -> this.start(scxSocket), resendDelayed);
            } else {
                this.clear();
            }
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001\u6210\u529f : {1}", scxSocket.clientID(), this.socketFrame.toJson());
            }
        }).onFailure(v -> {
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001\u5931\u8d25 : {1}", scxSocket.clientID(), this.socketFrame.toJson(), v);
            }
        });
    }

    public synchronized void cancelResend() {
        this.removeConnectFuture();
        if (this.resendTask != null) {
            this.resendTask.cancel();
            this.resendTask = null;
        }
    }

    public void clear() {
        this.cancelResend();
        this.sender.sendTaskMap.remove(this.socketFrame.seq_id);
    }

    public ScxSocketFrame socketFrame() {
        return this.socketFrame;
    }

    private synchronized void removeConnectFuture() {
        if (this.sendFuture != null) {
            this.sendFuture.onSuccess(null).onFailure(null);
            this.sendFuture = null;
        }
    }
}

