/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.PingPongManager;
import cool.scx.socket.ScxSocketClient;
import cool.scx.socket.ScxSocketStatus;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;

public final class ScxClientSocket
extends PingPongManager {
    private final ScxSocketClient socketClient;

    ScxClientSocket(WebSocket webSocket, String clientID, ScxSocketClient socketClient) {
        super((WebSocketBase)webSocket, clientID, socketClient.options);
        this.socketClient = socketClient;
    }

    ScxClientSocket(WebSocket webSocket, String clientID, ScxSocketClient socketClient, ScxSocketStatus status) {
        super((WebSocketBase)webSocket, clientID, socketClient.options, status);
        this.socketClient = socketClient;
    }

    @Override
    protected void doClose(Void unused) {
        super.doClose(unused);
        this.socketClient.connect();
    }

    @Override
    protected void doError(Throwable e) {
        super.doError(e);
        this.socketClient.connect();
    }

    @Override
    public void close() {
        this.socketClient.removeConnectFuture();
        this.socketClient.cancelReconnect();
        this.resetCloseOrErrorBind();
        super.close();
    }

    private void resetCloseOrErrorBind() {
        if (!this.webSocket.isClosed()) {
            this.webSocket.closeHandler(null);
            this.webSocket.exceptionHandler(null);
        }
    }

    @Override
    protected void doPingTimeout() {
        this.socketClient.connect();
    }
}

