/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.common.util.RandomUtils;
import cool.scx.common.util.SingleListenerFuture;
import cool.scx.socket.Helper;
import cool.scx.socket.ScxClientSocket;
import cool.scx.socket.ScxSocketClientOptions;
import io.netty.util.Timeout;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import java.util.function.Consumer;

public final class ScxSocketClient {
    private static final System.Logger logger = System.getLogger(ScxSocketClient.class.getName());
    final WebSocketConnectOptions connectOptions;
    final WebSocketClient webSocketClient;
    final String clientID;
    final ScxSocketClientOptions options;
    private ScxClientSocket clientSocket;
    private Consumer<ScxClientSocket> onConnect;
    private SingleListenerFuture<WebSocket> connectFuture;
    private Timeout reconnectTimeout;

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, String clientID, ScxSocketClientOptions options) {
        this.connectOptions = Helper.createConnectOptions(uri, clientID);
        this.webSocketClient = webSocketClient;
        this.clientID = clientID;
        this.options = options;
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, ScxSocketClientOptions options) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), options);
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient, String clientID) {
        this(uri, webSocketClient, clientID, new ScxSocketClientOptions());
    }

    public ScxSocketClient(String uri, WebSocketClient webSocketClient) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), new ScxSocketClientOptions());
    }

    public void onConnect(Consumer<ScxClientSocket> onConnect) {
        this.onConnect = onConnect;
    }

    private void _callOnConnect(ScxClientSocket clientSocket) {
        if (this.onConnect != null) {
            Thread.ofVirtual().name("scx-socket-client-call-on-connect").start(() -> this.onConnect.accept(clientSocket));
        }
    }

    public void connect() {
        if (this.connectFuture != null && !this.connectFuture.isComplete()) {
            return;
        }
        this._closeOldSocket();
        this.connectFuture = new SingleListenerFuture(this.webSocketClient.connect(this.connectOptions));
        this.connectFuture.onSuccess(webSocket -> {
            this.clientSocket = this.clientSocket != null ? new ScxClientSocket((WebSocket)webSocket, this.clientID, this, this.clientSocket.status) : new ScxClientSocket((WebSocket)webSocket, this.clientID, this);
            this.clientSocket.start();
            this._callOnConnect(this.clientSocket);
        }).onFailure(this::reconnect);
    }

    void reconnect(Throwable e) {
        if (this.reconnectTimeout != null) {
            return;
        }
        logger.log(System.Logger.Level.DEBUG, "WebSocket \u91cd\u8fde\u4e2d... CLIENT_ID : {0}", this.clientID);
        this.reconnectTimeout = Helper.setTimeout(() -> {
            this.reconnectTimeout = null;
            this.connect();
        }, this.options.getReconnectTimeout());
    }

    void cancelReconnect() {
        if (this.reconnectTimeout != null) {
            this.reconnectTimeout.cancel();
            this.reconnectTimeout = null;
        }
    }

    void removeConnectFuture() {
        if (this.connectFuture != null) {
            if (!this.connectFuture.isComplete()) {
                this.connectFuture.onSuccess(WebSocketBase::close).onFailure(null);
            }
            this.connectFuture = null;
        }
    }

    private void _closeOldSocket() {
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
    }
}

