/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.socket.Helper;
import cool.scx.socket.RequestOptions;
import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.ScxSocketRequest;
import cool.scx.socket.ScxSocketStatus;
import cool.scx.socket.SendOptions;
import io.vertx.core.http.WebSocketBase;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class EasyUseSocket
extends ScxSocket {
    private static final SendOptions DEFAULT_SEND_OPTIONS = new SendOptions();
    private static final RequestOptions DEFAULT_REQUEST_OPTIONS = new RequestOptions();

    EasyUseSocket(WebSocketBase webSocket, String clientID, ScxSocketOptions options, ScxSocketStatus status) {
        super(webSocket, clientID, options, status);
    }

    EasyUseSocket(WebSocketBase webSocket, String clientID, ScxSocketOptions options) {
        super(webSocket, clientID, options);
    }

    public final void send(String content) {
        this.send(this.status.frameCreator.createMessageFrame(content, DEFAULT_SEND_OPTIONS), DEFAULT_SEND_OPTIONS);
    }

    public final void send(String content, SendOptions options) {
        this.send(this.status.frameCreator.createMessageFrame(content, options), options);
    }

    public final void sendEvent(String eventName, String data) {
        this.send(this.status.frameCreator.createEventFrame(eventName, data, DEFAULT_SEND_OPTIONS), DEFAULT_SEND_OPTIONS);
    }

    public final void sendEvent(String eventName, String data, SendOptions options) {
        this.send(this.status.frameCreator.createEventFrame(eventName, data, options), options);
    }

    public final void sendEvent(String eventName, String data, BiConsumer<String, Throwable> responseCallback) {
        ScxSocketFrame eventFrame = this.status.frameCreator.createRequestFrame(eventName, data, DEFAULT_REQUEST_OPTIONS);
        this.status.requestManager.setResponseCallback(eventFrame, responseCallback, DEFAULT_REQUEST_OPTIONS);
        this.send(eventFrame, (SendOptions)DEFAULT_REQUEST_OPTIONS);
    }

    public final void sendEvent(String eventName, String data, BiConsumer<String, Throwable> responseCallback, RequestOptions options) {
        ScxSocketFrame eventFrame = this.status.frameCreator.createRequestFrame(eventName, data, options);
        this.status.requestManager.setResponseCallback(eventFrame, responseCallback, options);
        this.send(eventFrame, (SendOptions)options);
    }

    public final void send(Object data) {
        this.send(Helper.toJson(data));
    }

    public final void send(Object data, SendOptions options) {
        this.send(Helper.toJson(data), options);
    }

    public final void sendEvent(String eventName, Object data) {
        this.sendEvent(eventName, Helper.toJson(data));
    }

    public final void sendEvent(String eventName, Object data, SendOptions options) {
        this.sendEvent(eventName, Helper.toJson(data), options);
    }

    public final void sendEvent(String eventName, Object data, BiConsumer<String, Throwable> responseCallback) {
        this.sendEvent(eventName, Helper.toJson(data), responseCallback);
    }

    public final void sendEvent(String eventName, Object data, BiConsumer<String, Throwable> responseCallback, RequestOptions options) {
        this.sendEvent(eventName, Helper.toJson(data), responseCallback, options);
    }

    public final <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, Class<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e));
    }

    public final <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, RequestOptions options, Class<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e), options);
    }

    public final <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, TypeReference<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e));
    }

    public final <T> void sendEvent(String eventName, Object data, BiConsumer<T, Throwable> responseCallback, RequestOptions options, TypeReference<T> tClass) {
        this.sendEvent(eventName, Helper.toJson(data), (String s, Throwable e) -> responseCallback.accept(Helper.fromJson(s, tClass), (Throwable)e), options);
    }

    public final <T> void onEvent(String eventName, Consumer<T> onEvent, Class<T> tClass) {
        this.onEvent(eventName, (String s) -> onEvent.accept(Helper.fromJson(s, tClass)));
    }

    public final <T> void onEvent(String eventName, Function<T, ?> onEvent, Class<T> tClass) {
        this.onEvent(eventName, (String s) -> {
            Object data = onEvent.apply(Helper.fromJson(s, tClass));
            if (data instanceof String) {
                String str = (String)data;
                return str;
            }
            return Helper.toJson(data);
        });
    }

    public final <T> void onEvent(String eventName, Consumer<T> onEvent, TypeReference<T> tClass) {
        this.onEvent(eventName, (String s) -> onEvent.accept(Helper.fromJson(s, tClass)));
    }

    public final <T> void onEvent(String eventName, Function<T, ?> onEvent, TypeReference<T> tClass) {
        this.onEvent(eventName, (String s) -> {
            Object data = onEvent.apply(Helper.fromJson(s, tClass));
            if (data instanceof String) {
                String str = (String)data;
                return str;
            }
            return Helper.toJson(data);
        });
    }

    public final <T> void onEvent(String eventName, BiConsumer<T, TypeRequest> onEvent, Class<T> tClass) {
        this.onEvent(eventName, (String s, ScxSocketRequest r) -> onEvent.accept(Helper.fromJson(s, tClass), new TypeRequest((ScxSocketRequest)r)));
    }

    public final <T> void onEvent(String eventName, BiConsumer<T, TypeRequest> onEvent, TypeReference<T> tClass) {
        this.onEvent(eventName, (String s, ScxSocketRequest r) -> onEvent.accept(Helper.fromJson(s, tClass), new TypeRequest((ScxSocketRequest)r)));
    }

    public static class TypeRequest {
        private final ScxSocketRequest request;

        public TypeRequest(ScxSocketRequest r) {
            this.request = r;
        }

        public void response(String payload) {
            this.request.response(payload);
        }

        public void response(Object payload) {
            this.request.response(Helper.toJson(payload));
        }
    }
}

