/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.EasyUseSocket;
import cool.scx.socket.Helper;
import cool.scx.socket.PingPongOptions;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketStatus;
import io.netty.util.Timeout;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketBase;

abstract class PingPongManager
extends EasyUseSocket {
    private final PingPongOptions pingPongOptions;
    private Timeout ping;
    private Timeout pingTimeout;

    public PingPongManager(WebSocketBase webSocket, String clientID, PingPongOptions options, ScxSocketStatus status) {
        super(webSocket, clientID, options, status);
        this.pingPongOptions = options;
    }

    public PingPongManager(WebSocketBase webSocket, String clientID, PingPongOptions options) {
        super(webSocket, clientID, options);
        this.pingPongOptions = options;
    }

    private void startPingTimeout() {
        this.cancelPingTimeout();
        this.pingTimeout = Helper.setTimeout(this::doPingTimeout, this.pingPongOptions.getPingTimeout() + this.pingPongOptions.getPingInterval());
    }

    private void cancelPingTimeout() {
        if (this.pingTimeout != null) {
            this.pingTimeout.cancel();
            this.pingTimeout = null;
        }
    }

    protected void startPing() {
        this.cancelPing();
        this.ping = Helper.setTimeout(() -> {
            this.sendPing();
            this.startPing();
        }, this.pingPongOptions.getPingInterval());
    }

    private void cancelPing() {
        if (this.ping != null) {
            this.ping.cancel();
            this.ping = null;
        }
    }

    @Override
    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        this.startPing();
        this.startPingTimeout();
        switch (socketFrame.type) {
            case 3: {
                this.doPing(socketFrame);
                break;
            }
            case 4: {
                this.doPong(socketFrame);
                break;
            }
            default: {
                super.doSocketFrame(socketFrame);
            }
        }
    }

    @Override
    protected void start() {
        super.start();
        this.startPing();
        this.startPingTimeout();
    }

    @Override
    public void close() {
        super.close();
        this.cancelPing();
        this.cancelPingTimeout();
    }

    private void sendPing() {
        ScxSocketFrame pingFrame = this.status.frameCreator.createPingFrame();
        Future sendPingFuture = this.webSocket.writeTextMessage(pingFrame.toJson());
        sendPingFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PING \u6210\u529f : {1}", this.clientID, pingFrame.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PING \u5931\u8d25: {1}", this.clientID, pingFrame.toJson(), c);
            }
        });
    }

    private void sendPong() {
        ScxSocketFrame pongFrame = this.status.frameCreator.createPongFrame();
        Future sendPongFuture = this.webSocket.writeTextMessage(pongFrame.toJson());
        sendPongFuture.onSuccess(v -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PONG \u6210\u529f : {1}", this.clientID, pongFrame.toJson());
            }
        }).onFailure(c -> {
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PONG \u5931\u8d25 : {1}", this.clientID, pongFrame.toJson(), c);
            }
        });
    }

    private void doPing(ScxSocketFrame socketFrame) {
        this.sendPong();
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 PING : {1}", this.clientID, socketFrame.toJson());
        }
    }

    private void doPong(ScxSocketFrame socketFrame) {
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 PONG : {1}", this.clientID, socketFrame.toJson());
        }
    }

    protected abstract void doPingTimeout();
}

