/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.common.util.$;
import cool.scx.http.ScxServerWebSocket;
import cool.scx.http.ScxWebSocket;
import cool.scx.socket.PingPongManager;
import cool.scx.socket.ScxSocketServer;
import cool.scx.socket.ScxSocketStatus;

public final class ScxServerSocket
extends PingPongManager {
    private final ScxSocketServer scxSocketServer;
    private $.Timeout removeClosedClientTimeout;

    ScxServerSocket(ScxServerWebSocket serverWebSocket, String clientID, ScxSocketServer scxSocketServer) {
        super((ScxWebSocket)serverWebSocket, clientID, scxSocketServer.options);
        this.scxSocketServer = scxSocketServer;
    }

    ScxServerSocket(ScxServerWebSocket serverWebSocket, String clientID, ScxSocketServer scxSocketServer, ScxSocketStatus status) {
        super((ScxWebSocket)serverWebSocket, clientID, scxSocketServer.options, status);
        this.scxSocketServer = scxSocketServer;
    }

    @Override
    protected void start() {
        super.start();
        this.cancelRemoveClosedClientTask();
    }

    @Override
    public void close() {
        this.startRemoveClosedClientTask();
        super.close();
    }

    private void startRemoveClosedClientTask() {
        this.cancelRemoveClosedClientTask();
        this.removeClosedClientTimeout = $.setTimeout(this::removeClosedClient, (long)this.scxSocketServer.options.getStatusKeepTime());
    }

    private void cancelRemoveClosedClientTask() {
        if (this.removeClosedClientTimeout != null) {
            this.removeClosedClientTimeout.cancel();
            this.removeClosedClientTimeout = null;
        }
    }

    private void removeClosedClient() {
        this.scxSocketServer.serverSockets.remove(this.clientID);
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u5ba2\u6237\u7aef\u8d85\u65f6\u672a\u8fde\u63a5 \u5df2\u79fb\u9664", this.clientID);
        }
    }

    @Override
    protected void startPing() {
    }

    @Override
    protected void doPingTimeout() {
        this.close();
    }
}

