/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.common.util.$;
import cool.scx.socket.FrameSender;
import cool.scx.socket.Helper;
import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.SendOptions;
import java.util.concurrent.atomic.AtomicInteger;

final class SendTask {
    private static final System.Logger logger = System.getLogger(SendTask.class.getName());
    private final ScxSocketFrame socketFrame;
    private final SendOptions options;
    private final AtomicInteger sendTimes;
    private final FrameSender sender;
    private $.Timeout resendTask;

    public SendTask(ScxSocketFrame socketFrame, SendOptions options, FrameSender sender) {
        this.socketFrame = socketFrame;
        this.options = options;
        this.sendTimes = new AtomicInteger(0);
        this.sender = sender;
    }

    public synchronized void start(ScxSocket scxSocket) {
        block8: {
            if (scxSocket.isClosed()) {
                return;
            }
            if (this.sendTimes.get() > this.options.getMaxResendTimes()) {
                if (this.options.getGiveUpIfReachMaxResendTimes()) {
                    this.clear();
                }
                return;
            }
            try {
                scxSocket.webSocket.send(this.socketFrame.toJson());
                int currentSendTime = this.sendTimes.getAndIncrement();
                if (this.options.getNeedAck()) {
                    long resendDelayed = Math.max(Helper.getDelayed(currentSendTime), this.options.getMaxResendDelayed());
                    this.resendTask = $.setTimeout(() -> this.start(scxSocket), (long)resendDelayed);
                } else {
                    this.clear();
                }
                if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                    logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001\u6210\u529f : {1}", scxSocket.clientID(), this.socketFrame.toJson());
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(System.Logger.Level.DEBUG)) break block8;
                logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001\u5931\u8d25 : {1}", scxSocket.clientID(), this.socketFrame.toJson(), e);
            }
        }
    }

    public synchronized void cancelResend() {
        this.removeConnectFuture();
        if (this.resendTask != null) {
            this.resendTask.cancel();
            this.resendTask = null;
        }
    }

    public void clear() {
        this.cancelResend();
        this.sender.sendTaskMap.remove(this.socketFrame.seq_id);
    }

    public ScxSocketFrame socketFrame() {
        return this.socketFrame;
    }

    private synchronized void removeConnectFuture() {
    }
}

