/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.socket.Helper;
import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;

public final class ScxSocketRequest {
    private final ScxSocket scxSocket;
    private final ScxSocketFrame socketFrame;
    private boolean alreadyResponse;

    public ScxSocketRequest(ScxSocket scxSocket, ScxSocketFrame socketFrame) {
        this.scxSocket = scxSocket;
        this.socketFrame = socketFrame;
        this.alreadyResponse = false;
    }

    ScxSocketFrame socketFrame() {
        return this.socketFrame;
    }

    public void response(String payload) {
        if (this.alreadyResponse) {
            throw new UnsupportedOperationException("\u5df2\u7ecf\u54cd\u5e94\u8fc7 !!!");
        }
        this.alreadyResponse = true;
        this.scxSocket.sendResponse(this.socketFrame.seq_id, payload);
    }

    public void response(Object payload) {
        this.response(Helper.toJson(payload));
    }

    public String payload() {
        return this.socketFrame.payload;
    }

    public <T> T payload(TypeReference<T> valueTypeRef) {
        return Helper.fromJson(this.payload(), valueTypeRef);
    }
}

