/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.SendOptions;
import java.util.concurrent.atomic.AtomicLong;

final class FrameCreator {
    private final AtomicLong nowSeqID = new AtomicLong(0L);

    public ScxSocketFrame createPingFrame() {
        ScxSocketFrame pingFrame = new ScxSocketFrame();
        pingFrame.type = (byte)3;
        return pingFrame;
    }

    public ScxSocketFrame createPongFrame() {
        ScxSocketFrame pongFrame = new ScxSocketFrame();
        pongFrame.type = (byte)4;
        return pongFrame;
    }

    public ScxSocketFrame createAckFrame(long ack_id) {
        ScxSocketFrame ackFrame = new ScxSocketFrame();
        ackFrame.type = (byte)2;
        ackFrame.ack_id = ack_id;
        return ackFrame;
    }

    public ScxSocketFrame createAckFrame(long ack_id, String payload) {
        ScxSocketFrame ackFrame = this.createAckFrame(ack_id);
        ackFrame.payload = payload;
        return ackFrame;
    }

    private ScxSocketFrame createBaseFrame(String content, SendOptions options) {
        ScxSocketFrame baseFrame = new ScxSocketFrame();
        baseFrame.seq_id = this.nowSeqID.getAndIncrement();
        baseFrame.now = System.currentTimeMillis();
        baseFrame.need_ack = options.getNeedAck();
        baseFrame.payload = content;
        return baseFrame;
    }

    public ScxSocketFrame createMessageFrame(String content, SendOptions options) {
        ScxSocketFrame messageFrame = this.createBaseFrame(content, options);
        messageFrame.type = 0;
        return messageFrame;
    }

    public ScxSocketFrame createEventFrame(String eventName, String payload, SendOptions options) {
        ScxSocketFrame eventFrame = this.createMessageFrame(payload, options);
        eventFrame.event_name = eventName;
        return eventFrame;
    }

    public ScxSocketFrame createRequestFrame(String eventName, String payload, SendOptions options) {
        ScxSocketFrame requestFrame = this.createEventFrame(eventName, payload, options);
        requestFrame.need_response = true;
        return requestFrame;
    }

    public ScxSocketFrame createResponseFrame(long ack_id, String payload, SendOptions options) {
        ScxSocketFrame responseFrame = this.createBaseFrame(payload, options);
        responseFrame.type = 1;
        responseFrame.ack_id = ack_id;
        return responseFrame;
    }
}

