/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.http.ScxWebSocket;
import cool.scx.socket.PingPongManager;
import cool.scx.socket.ScxSocketClient;
import cool.scx.socket.ScxSocketStatus;

public final class ScxClientSocket
extends PingPongManager {
    private final ScxSocketClient socketClient;

    ScxClientSocket(ScxWebSocket webSocket, String clientID, ScxSocketClient socketClient) {
        super(webSocket, clientID, socketClient.options);
        this.socketClient = socketClient;
    }

    ScxClientSocket(ScxWebSocket webSocket, String clientID, ScxSocketClient socketClient, ScxSocketStatus status) {
        super(webSocket, clientID, socketClient.options, status);
        this.socketClient = socketClient;
    }

    @Override
    protected void doClose(Integer code, String reason) {
        super.doClose(code, reason);
        this.socketClient.connect();
    }

    @Override
    protected void doError(Throwable e) {
        super.doError(e);
        this.socketClient.connect();
    }

    @Override
    public void close() {
        this.socketClient.removeConnectFuture();
        this.socketClient.cancelReconnect();
        this.resetCloseOrErrorBind();
        super.close();
    }

    private void resetCloseOrErrorBind() {
        if (!this.webSocket.isClosed()) {
            this.webSocket.onClose(null);
            this.webSocket.onError(null);
        }
    }

    @Override
    protected void doPingTimeout() {
        this.socketClient.connect();
    }
}

