/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.scx.common.exception.ScxExceptionHelper;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.web_socket.ScxServerWebSocket;

public final class Helper {
    public static final String SCX_SOCKET_CLIENT_ID = "scx-socket-client-id";
    private static final ObjectMapper JSON_MAPPER = ObjectUtils.jsonMapper();

    public static String getClientID(ScxServerWebSocket serverWebSocket) {
        return serverWebSocket.uri().getQuery(SCX_SOCKET_CLIENT_ID);
    }

    public static ScxURIWritable createConnectOptions(String absoluteURI, String clientID) {
        return ScxURI.of((String)absoluteURI).setQuery(SCX_SOCKET_CLIENT_ID, new String[]{clientID});
    }

    public static long getDelayed(int times) {
        return 1000L * (1L << times);
    }

    public static String toJson(Object data) {
        return (String)ScxExceptionHelper.wrap(() -> JSON_MAPPER.writeValueAsString(data));
    }

    public static <T> T fromJson(String json, Class<T> tClass) {
        return (T)(json == null ? null : ScxExceptionHelper.wrap(() -> JSON_MAPPER.readValue(json, tClass)));
    }

    public static <T> T fromJson(String json, TypeReference<T> valueTypeRef) {
        return (T)(json == null ? null : ScxExceptionHelper.wrap(() -> JSON_MAPPER.readValue(json, valueTypeRef)));
    }
}

