/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.http.web_socket.ScxWebSocket;
import cool.scx.socket.EasyUseSocket;
import cool.scx.socket.PingPongOptions;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketStatus;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

abstract class PingPongManager
extends EasyUseSocket {
    private final PingPongOptions pingPongOptions;
    private ScheduledFuture<?> ping;
    private ScheduledFuture<?> pingTimeout;

    public PingPongManager(ScxWebSocket webSocket, String clientID, PingPongOptions options, ScxSocketStatus status) {
        super(webSocket, clientID, options, status);
        this.pingPongOptions = options;
    }

    public PingPongManager(ScxWebSocket webSocket, String clientID, PingPongOptions options) {
        super(webSocket, clientID, options);
        this.pingPongOptions = options;
    }

    private void startPingTimeout() {
        this.cancelPingTimeout();
        this.pingTimeout = this.scheduledExecutor.schedule(this::doPingTimeout, (long)(this.pingPongOptions.getPingTimeout() + this.pingPongOptions.getPingInterval()), TimeUnit.MILLISECONDS);
    }

    private void cancelPingTimeout() {
        if (this.pingTimeout != null) {
            this.pingTimeout.cancel(false);
            this.pingTimeout = null;
        }
    }

    protected void startPing() {
        this.cancelPing();
        this.ping = this.scheduledExecutor.schedule(() -> {
            this.sendPing();
            this.startPing();
        }, (long)this.pingPongOptions.getPingInterval(), TimeUnit.MILLISECONDS);
    }

    private void cancelPing() {
        if (this.ping != null) {
            this.ping.cancel(false);
            this.ping = null;
        }
    }

    @Override
    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        this.startPing();
        this.startPingTimeout();
        switch (socketFrame.type) {
            case 3: {
                this.doPing(socketFrame);
                break;
            }
            case 4: {
                this.doPong(socketFrame);
                break;
            }
            default: {
                super.doSocketFrame(socketFrame);
            }
        }
    }

    @Override
    protected void start() {
        super.start();
        this.startPing();
        this.startPingTimeout();
    }

    @Override
    public void close() {
        super.close();
        this.cancelPing();
        this.cancelPingTimeout();
    }

    private void sendPing() {
        block3: {
            ScxSocketFrame pingFrame = this.status.frameCreator.createPingFrame();
            try {
                this.webSocket.send(pingFrame.toJson());
                if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                    this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PING \u6210\u529f : {1}", this.clientID, pingFrame.toJson());
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(System.Logger.Level.DEBUG)) break block3;
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PING \u5931\u8d25: {1}", this.clientID, pingFrame.toJson(), e);
            }
        }
    }

    private void sendPong() {
        block3: {
            ScxSocketFrame pongFrame = this.status.frameCreator.createPongFrame();
            try {
                this.webSocket.send(pongFrame.toJson());
                if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                    this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PONG \u6210\u529f : {1}", this.clientID, pongFrame.toJson());
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(System.Logger.Level.DEBUG)) break block3;
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 PONG \u5931\u8d25 : {1}", this.clientID, pongFrame.toJson(), e);
            }
        }
    }

    private void doPing(ScxSocketFrame socketFrame) {
        this.sendPong();
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 PING : {1}", this.clientID, socketFrame.toJson());
        }
    }

    private void doPong(ScxSocketFrame socketFrame) {
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 PONG : {1}", this.clientID, socketFrame.toJson());
        }
    }

    protected abstract void doPingTimeout();
}

