/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.SendOptions;
import cool.scx.socket.SendTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;

final class FrameSender {
    final ConcurrentMap<Long, SendTask> sendTaskMap = new ConcurrentHashMap<Long, SendTask>();
    final ScheduledExecutorService scheduledExecutor;

    public FrameSender(ScxSocketOptions options) {
        this.scheduledExecutor = options.scheduledExecutor();
    }

    public void clearSendTask(ScxSocketFrame ackFrame) {
        SendTask sendTask = (SendTask)this.sendTaskMap.get(ackFrame.ack_id);
        if (sendTask != null) {
            sendTask.clear();
        }
    }

    public void send(ScxSocketFrame socketFrame, SendOptions options, ScxSocket scxSocket) {
        SendTask sendTask = new SendTask(socketFrame, options, this);
        this.sendTaskMap.put(socketFrame.seq_id, sendTask);
        sendTask.start(scxSocket);
    }

    public void startAllSendTask(ScxSocket scxSocket) {
        for (SendTask value : this.sendTaskMap.values()) {
            value.start(scxSocket);
        }
    }

    public void cancelAllResendTask() {
        for (SendTask value : this.sendTaskMap.values()) {
            value.cancelResend();
        }
    }
}

