/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.RequestManager;
import cool.scx.socket.RequestOptions;
import cool.scx.socket.ScxSocketResponse;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

final class RequestTask {
    private final Consumer<ScxSocketResponse> responseCallback;
    private final RequestManager requestManager;
    private final RequestOptions options;
    private final long seq_id;
    private final ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> failTimeout;

    public RequestTask(Consumer<ScxSocketResponse> responseCallback, RequestManager requestManager, RequestOptions options, long seqId) {
        this.responseCallback = responseCallback;
        this.requestManager = requestManager;
        this.options = options;
        this.seq_id = seqId;
        this.scheduledExecutor = requestManager.scheduledExecutor;
    }

    public void start() {
        this.cancelFail();
        this.failTimeout = this.scheduledExecutor.schedule(this::fail, (long)this.options.getRequestTimeout(), TimeUnit.MILLISECONDS);
    }

    public void success(String payload) {
        this.clear();
        this.responseCallback.accept(new ScxSocketResponse(payload));
    }

    public void fail() {
        this.clear();
        this.responseCallback.accept(new ScxSocketResponse(new RuntimeException("\u8d85\u65f6")));
    }

    public void cancelFail() {
        if (this.failTimeout != null) {
            this.failTimeout.cancel(false);
            this.failTimeout = null;
        }
    }

    public void clear() {
        this.cancelFail();
        this.requestManager.responseTaskMap.remove(this.seq_id);
    }
}

