/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.common.util.StringUtils;
import cool.scx.socket.RequestOptions;
import cool.scx.socket.ScxSocketFrame;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.ScxSocketRequest;
import cool.scx.socket.ScxSocketResponse;
import cool.scx.socket.ScxSocketStatus;
import cool.scx.socket.SendOptions;
import cool.scx.websocket.ScxWebSocket;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ScxSocket {
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    final ScxWebSocket webSocket;
    final String clientID;
    final ScxSocketOptions options;
    final ScxSocketStatus status;
    final ScheduledExecutorService scheduledExecutor;
    final Executor executor;
    private final ConcurrentMap<String, Consumer<ScxSocketRequest>> onEventMap;
    private Consumer<String> onMessage;
    private BiConsumer<Integer, String> onClose;
    private Consumer<Throwable> onError;

    ScxSocket(ScxWebSocket webSocket, String clientID, ScxSocketOptions options, ScxSocketStatus status) {
        this.webSocket = webSocket;
        this.clientID = clientID;
        this.options = options;
        this.status = status;
        this.scheduledExecutor = options.scheduledExecutor();
        this.executor = options.executor();
        this.onEventMap = new ConcurrentHashMap<String, Consumer<ScxSocketRequest>>();
        this.onMessage = null;
        this.onClose = null;
        this.onError = null;
    }

    ScxSocket(ScxWebSocket webSocket, String clientID, ScxSocketOptions options) {
        this(webSocket, clientID, options, new ScxSocketStatus(options));
    }

    public final String clientID() {
        return this.clientID;
    }

    public final void send(ScxSocketFrame socketFrame, SendOptions options) {
        this.status.frameSender.send(socketFrame, options, this);
    }

    public final void send(String content, SendOptions options) {
        this.send(this.status.frameCreator.createMessageFrame(content, options), options);
    }

    public final void sendEvent(String eventName, String data, SendOptions options) {
        this.send(this.status.frameCreator.createEventFrame(eventName, data, options), options);
    }

    public final void sendEvent(String eventName, String data, Consumer<ScxSocketResponse> responseCallback, RequestOptions options) {
        ScxSocketFrame eventFrame = this.status.frameCreator.createRequestFrame(eventName, data, options);
        this.status.requestManager.setResponseCallback(eventFrame, responseCallback, options);
        this.send(eventFrame, (SendOptions)options);
    }

    public final void sendResponse(long ack_id, String responseData) {
        SendOptions sendOptions = new SendOptions();
        ScxSocketFrame responseFrame = this.status.frameCreator.createResponseFrame(ack_id, responseData, sendOptions);
        this.send(responseFrame, sendOptions);
    }

    private void sendAck(long ack_id) {
        block3: {
            ScxSocketFrame ackFrame = this.status.frameCreator.createAckFrame(ack_id);
            try {
                this.webSocket.send(ackFrame.toJson());
                if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                    this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u6210\u529f : {1}", this.clientID, ackFrame.toJson());
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(System.Logger.Level.DEBUG)) break block3;
                this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u53d1\u9001 ACK \u5931\u8d25 : {1}", this.clientID, ackFrame.toJson(), e);
            }
        }
    }

    public final void onMessage(Consumer<String> onMessage) {
        this.onMessage = onMessage;
    }

    public final void onClose(BiConsumer<Integer, String> onClose) {
        this.onClose = onClose;
        if (this.webSocket.isClosed()) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    public final void onError(Consumer<Throwable> onError) {
        this.onError = onError;
        if (this.webSocket.isClosed()) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    public final void onEvent(String eventName, Consumer<ScxSocketRequest> onEvent) {
        this.onEventMap.put(eventName, onEvent);
    }

    public final void removeEvent(String eventName) {
        this.onEventMap.remove(eventName);
    }

    protected void doSocketFrame(ScxSocketFrame socketFrame) {
        switch (socketFrame.type) {
            case 0: {
                this.doMessage(socketFrame);
                break;
            }
            case 1: {
                this.doResponse(socketFrame);
                break;
            }
            case 2: {
                this.doAck(socketFrame);
            }
        }
    }

    private void doMessage(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        if (StringUtils.isBlank((String)socketFrame.event_name)) {
            this.callOnMessageWithCheckDuplicate(socketFrame);
        } else {
            this.callOnEventWithCheckDuplicate(socketFrame);
        }
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230\u6d88\u606f : {1}", this.clientID, socketFrame.toJson());
        }
    }

    private void doResponse(ScxSocketFrame socketFrame) {
        if (socketFrame.need_ack) {
            this.sendAck(socketFrame.seq_id);
        }
        this.status.requestManager.success(socketFrame);
    }

    private void doAck(ScxSocketFrame ackFrame) {
        this.status.frameSender.clearSendTask(ackFrame);
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u6536\u5230 ACK : {1}", this.clientID, ackFrame.toJson());
        }
    }

    protected void doClose(int code, String reason) {
        this.close();
        this._callOnClose(code, reason);
    }

    protected void doError(Throwable e) {
        this.close();
        this._callOnError(e);
    }

    private void bind() {
        this.webSocket.onTextMessage((t, bl) -> this.doSocketFrame(ScxSocketFrame.fromJson(t)));
        this.webSocket.onClose(this::doClose);
        this.webSocket.onError(this::doError);
    }

    protected void start() {
        this.bind();
        this.status.frameSender.startAllSendTask(this);
        this.status.duplicateFrameChecker.startAllClearTask();
    }

    public void close() {
        this.closeWebSocket();
        this.status.frameSender.cancelAllResendTask();
        this.status.duplicateFrameChecker.cancelAllClearTask();
    }

    protected void closeWebSocket() {
        block4: {
            if (!this.webSocket.isClosed()) {
                try {
                    this.webSocket.close();
                    if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                        this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u5173\u95ed\u6210\u529f", this.clientID);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(System.Logger.Level.DEBUG)) break block4;
                    this.logger.log(System.Logger.Level.DEBUG, "CLIENT_ID : {0}, \u5173\u95ed\u5931\u8d25", this.clientID, e);
                }
            }
        }
    }

    public boolean isClosed() {
        return this.webSocket.isClosed();
    }

    private void callOnMessageWithCheckDuplicate(ScxSocketFrame socketFrame) {
        if (this.status.duplicateFrameChecker.check(socketFrame)) {
            this._callOnMessage(socketFrame.payload);
        }
    }

    private void callOnEventWithCheckDuplicate(ScxSocketFrame socketFrame) {
        if (this.status.duplicateFrameChecker.check(socketFrame)) {
            this._callOnEvent(socketFrame);
        }
    }

    private void _callOnMessage(String message) {
        if (this.onMessage != null) {
            this.executor.execute(() -> this.onMessage.accept(message));
        }
    }

    private void _callOnClose(Integer code, String reason) {
        if (this.onClose != null) {
            this.executor.execute(() -> this.onClose.accept(code, reason));
        }
    }

    private void _callOnError(Throwable e) {
        if (this.onError != null) {
            this.executor.execute(() -> this.onError.accept(e));
        }
    }

    private void _callOnEvent(ScxSocketFrame socketFrame) {
        Consumer onEvent = (Consumer)this.onEventMap.get(socketFrame.event_name);
        if (onEvent != null) {
            this.executor.execute(() -> {
                ScxSocketRequest socketRequest = new ScxSocketRequest(this, socketFrame);
                onEvent.accept(socketRequest);
            });
        }
    }
}

