/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.Helper;
import cool.scx.socket.ScxServerSocket;
import cool.scx.socket.ScxSocketServerOptions;
import cool.scx.websocket.ScxServerWebSocketHandshakeRequest;
import cool.scx.websocket.ScxWebSocket;
import cool.scx.websocket.handler.ScxEventWebSocket;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public final class ScxSocketServer {
    final ConcurrentMap<String, ScxServerSocket> serverSockets;
    final ScxSocketServerOptions options;
    final Executor executor;
    private Consumer<ScxServerSocket> onConnect;

    public ScxSocketServer() {
        this(new ScxSocketServerOptions());
    }

    public ScxSocketServer(ScxSocketServerOptions options) {
        this.options = options;
        this.serverSockets = new ConcurrentHashMap<String, ScxServerSocket>();
        this.executor = options.executor();
    }

    public void onConnect(Consumer<ScxServerSocket> onConnect) {
        this.onConnect = onConnect;
    }

    private void _callOnConnect(ScxServerSocket serverSocket) {
        if (this.onConnect != null) {
            this.executor.execute(() -> this.onConnect.accept(serverSocket));
        }
    }

    public void call(ScxServerWebSocketHandshakeRequest handshakeRequest) {
        String clientID = Helper.getClientID(handshakeRequest);
        if (clientID == null) {
            handshakeRequest.response().status(400).send();
            return;
        }
        ScxEventWebSocket serverWebSocket = ScxEventWebSocket.of((ScxWebSocket)handshakeRequest.webSocket());
        ScxServerSocket serverSocket = this.serverSockets.compute(clientID, (k, old) -> {
            if (old == null) {
                return new ScxServerSocket(serverWebSocket, clientID, this);
            }
            old.close();
            return new ScxServerSocket(serverWebSocket, clientID, this, old.status);
        });
        serverSocket.start();
        this._callOnConnect(serverSocket);
    }

    public ScxServerSocket getServerSocket(String clientID) {
        return (ScxServerSocket)this.serverSockets.get(clientID);
    }

    public Collection<ScxServerSocket> getServerSockets() {
        return this.serverSockets.values();
    }
}

