/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.common.util.RandomUtils;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.socket.Helper;
import cool.scx.socket.ScxClientSocket;
import cool.scx.socket.ScxSocketClientOptions;
import cool.scx.websocket.ScxWebSocket;
import cool.scx.websocket.ScxWebSocketClient;
import cool.scx.websocket.event.ScxEventWebSocket;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class ScxSocketClient {
    private static final System.Logger logger = System.getLogger(ScxSocketClient.class.getName());
    final ScxURIWritable connectOptions;
    final ScxWebSocketClient webSocketClient;
    final String clientID;
    final ScxSocketClientOptions options;
    final ScheduledExecutorService scheduledExecutor;
    final Executor executor;
    private ScxClientSocket clientSocket;
    private Consumer<ScxClientSocket> onConnect;
    private ScheduledFuture<?> reconnectTimeout;

    public ScxSocketClient(String uri, ScxWebSocketClient webSocketClient, String clientID, ScxSocketClientOptions options) {
        this.connectOptions = Helper.createConnectOptions(uri, clientID);
        this.webSocketClient = webSocketClient;
        this.clientID = clientID;
        this.options = options;
        this.scheduledExecutor = options.scheduledExecutor();
        this.executor = options.executor();
    }

    public ScxSocketClient(String uri, ScxWebSocketClient webSocketClient, ScxSocketClientOptions options) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), options);
    }

    public ScxSocketClient(String uri, ScxWebSocketClient webSocketClient, String clientID) {
        this(uri, webSocketClient, clientID, new ScxSocketClientOptions());
    }

    public ScxSocketClient(String uri, ScxWebSocketClient webSocketClient) {
        this(uri, webSocketClient, RandomUtils.randomUUID(), new ScxSocketClientOptions());
    }

    public void onConnect(Consumer<ScxClientSocket> onConnect) {
        this.onConnect = onConnect;
    }

    private void _callOnConnect(ScxClientSocket clientSocket) {
        if (this.onConnect != null) {
            this.executor.execute(() -> this.onConnect.accept(clientSocket));
        }
    }

    public void connect() {
        this._closeOldSocket();
        try {
            ScxWebSocket ws = this.webSocketClient.webSocketHandshakeRequest().uri((ScxURI)this.connectOptions).webSocket();
            ScxEventWebSocket webSocket = ScxEventWebSocket.of((ScxWebSocket)ws, (Executor)this.executor);
            this.clientSocket = this.clientSocket != null ? new ScxClientSocket(webSocket, this.clientID, this, this.clientSocket.status) : new ScxClientSocket(webSocket, this.clientID, this);
            this.clientSocket.start();
            this._callOnConnect(this.clientSocket);
        }
        catch (Exception e) {
            this.reconnect(e);
        }
    }

    void reconnect(Throwable e) {
        if (this.reconnectTimeout != null) {
            return;
        }
        logger.log(System.Logger.Level.DEBUG, "WebSocket \u91cd\u8fde\u4e2d... CLIENT_ID : {0}", this.clientID, e);
        this.reconnectTimeout = this.scheduledExecutor.schedule(() -> {
            this.reconnectTimeout = null;
            this.connect();
        }, (long)this.options.getReconnectTimeout(), TimeUnit.MILLISECONDS);
    }

    void cancelReconnect() {
        if (this.reconnectTimeout != null) {
            this.reconnectTimeout.cancel(false);
            this.reconnectTimeout = null;
        }
    }

    void removeConnectFuture() {
    }

    private void _closeOldSocket() {
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
    }
}

