/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.socket.Helper;
import cool.scx.socket.RequestOptions;
import cool.scx.socket.ScxSocket;
import cool.scx.socket.ScxSocketOptions;
import cool.scx.socket.ScxSocketRequest;
import cool.scx.socket.ScxSocketResponse;
import cool.scx.socket.ScxSocketStatus;
import cool.scx.socket.SendOptions;
import cool.scx.websocket.event.ScxEventWebSocket;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class EasyUseSocket
extends ScxSocket {
    private static final SendOptions DEFAULT_SEND_OPTIONS = new SendOptions();
    private static final RequestOptions DEFAULT_REQUEST_OPTIONS = new RequestOptions();

    EasyUseSocket(ScxEventWebSocket webSocket, String clientID, ScxSocketOptions options, ScxSocketStatus status) {
        super(webSocket, clientID, options, status);
    }

    EasyUseSocket(ScxEventWebSocket webSocket, String clientID, ScxSocketOptions options) {
        super(webSocket, clientID, options);
    }

    public final void send(String content) {
        this.send(content, DEFAULT_SEND_OPTIONS);
    }

    public final void send(Object data) {
        this.send(Helper.toJson(data), DEFAULT_SEND_OPTIONS);
    }

    public final void send(Object data, SendOptions options) {
        this.send(Helper.toJson(data), options);
    }

    public final void sendEvent(String eventName) {
        this.sendEvent(eventName, null, DEFAULT_SEND_OPTIONS);
    }

    public final void sendEvent(String eventName, String data) {
        this.sendEvent(eventName, data, DEFAULT_SEND_OPTIONS);
    }

    public final void sendEvent(String eventName, Object data) {
        this.sendEvent(eventName, Helper.toJson(data), DEFAULT_SEND_OPTIONS);
    }

    public final void sendEvent(String eventName, Object data, SendOptions options) {
        this.sendEvent(eventName, Helper.toJson(data), options);
    }

    public final void sendEvent(String eventName, Consumer<ScxSocketResponse> responseCallback) {
        this.sendEvent(eventName, null, responseCallback, DEFAULT_REQUEST_OPTIONS);
    }

    public final void sendEvent(String eventName, Consumer<ScxSocketResponse> responseCallback, RequestOptions options) {
        this.sendEvent(eventName, null, responseCallback, options);
    }

    public final void sendEvent(String eventName, Object data, Consumer<ScxSocketResponse> responseCallback) {
        this.sendEvent(eventName, Helper.toJson(data), responseCallback, DEFAULT_REQUEST_OPTIONS);
    }

    public final void sendEvent(String eventName, Object data, Consumer<ScxSocketResponse> responseCallback, RequestOptions options) {
        this.sendEvent(eventName, Helper.toJson(data), responseCallback, options);
    }

    public final void onEvent(String eventName, Runnable onEvent) {
        ((ScxSocket)this).onEvent(eventName, (ScxSocketRequest r) -> {
            onEvent.run();
            if (r.socketFrame().need_response) {
                r.response(null);
            }
        });
    }

    public final <T> void onEvent(String eventName, Consumer<T> onEvent, TypeReference<T> valueTypeRef) {
        ((ScxSocket)this).onEvent(eventName, (ScxSocketRequest r) -> {
            onEvent.accept(r.payload(valueTypeRef));
            if (r.socketFrame().need_response) {
                r.response(null);
            }
        });
    }

    public final void onEvent(String eventName, Supplier<?> onEvent) {
        ((ScxSocket)this).onEvent(eventName, (ScxSocketRequest r) -> {
            Object data = onEvent.get();
            if (r.socketFrame().need_response) {
                r.response(Helper.toJson(data));
            }
        });
    }

    public final <T> void onEvent(String eventName, Function<T, ?> onEvent, TypeReference<T> valueTypeRef) {
        ((ScxSocket)this).onEvent(eventName, (ScxSocketRequest r) -> {
            Object data = onEvent.apply(r.payload(valueTypeRef));
            if (r.socketFrame().need_response) {
                r.response(Helper.toJson(data));
            }
        });
    }
}

