/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.socket;

import cool.scx.socket.DuplicateFrameChecker;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class ClearTask {
    private final DuplicateFrameChecker checker;
    private final DuplicateFrameChecker.Key key;
    private final ScheduledExecutorService scheduledExecutor;
    private final Lock lock = new ReentrantLock();
    private ScheduledFuture<?> clearTimeout;

    public ClearTask(DuplicateFrameChecker.Key key, DuplicateFrameChecker checker) {
        this.key = key;
        this.checker = checker;
        this.scheduledExecutor = checker.scheduledExecutor;
    }

    public void start() {
        this.lock.lock();
        try {
            this.cancel();
            this.clearTimeout = this.scheduledExecutor.schedule(this::clear, this.checker.getClearTimeout(), TimeUnit.MILLISECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel() {
        this.lock.lock();
        try {
            if (this.clearTimeout != null) {
                this.clearTimeout.cancel(false);
                this.clearTimeout = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clear() {
        this.checker.clearTaskMap.remove(this.key);
    }
}

