/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.ScxTCPClient;
import cool.scx.tcp.ScxTCPClientOptions;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.TCPSocket;
import cool.scx.tcp.proxy.Proxy;
import cool.scx.tcp.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.ssl.SSLSocket;

public class TCPClient
implements ScxTCPClient {
    private final ScxTCPClientOptions options;

    public TCPClient() {
        this(new ScxTCPClientOptions());
    }

    public TCPClient(ScxTCPClientOptions options) {
        this.options = options;
    }

    @Override
    public ScxTCPSocket connect(SocketAddress endpoint) {
        Socket socket;
        TLS tls = this.options.tls();
        Proxy proxy = this.options.proxy();
        try {
            socket = tls != null && tls.enabled() ? tls.createSocket() : new Socket();
            socket.connect(endpoint);
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u5ba2\u6237\u7aef\u8fde\u63a5\u5931\u8d25 !!!", e);
        }
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            try {
                sslSocket.startHandshake();
            }
            catch (IOException e) {
                try {
                    sslSocket.close();
                }
                catch (IOException ce) {
                    e.addSuppressed(ce);
                }
                throw new UncheckedIOException("\u5ba2\u6237\u7aef SSL \u63e1\u624b\u5931\u8d25 !!!", e);
            }
        }
        return new TCPSocket(socket);
    }
}

