/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.ScxTCPServer;
import cool.scx.tcp.ScxTCPServerOptions;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.TCPSocket;
import cool.scx.tcp.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocket;

public class TCPServer
implements ScxTCPServer {
    private static final System.Logger LOGGER = System.getLogger(TCPServer.class.getName());
    private final ScxTCPServerOptions options;
    private final Thread serverThread;
    private Consumer<ScxTCPSocket> connectHandler;
    private ServerSocket serverSocket;
    private boolean running;

    public TCPServer() {
        this(new ScxTCPServerOptions());
    }

    public TCPServer(ScxTCPServerOptions options) {
        this.options = options;
        this.serverThread = Thread.ofPlatform().name("TCPServer-Listener").unstarted(this::listen);
    }

    @Override
    public ScxTCPServer onConnect(Consumer<ScxTCPSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public void start() {
        if (this.running) {
            throw new IllegalStateException("\u670d\u52a1\u5668\u5df2\u5728\u8fd0\u884c !!!");
        }
        TLS tls = this.options.tls();
        try {
            this.serverSocket = tls != null && tls.enabled() ? tls.createServerSocket() : new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(this.options.port()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u542f\u52a8\u670d\u52a1\u5668\u5931\u8d25 !!!", e);
        }
        this.running = true;
        this.serverThread.start();
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u5173\u95ed\u670d\u52a1\u5668\u5931\u8d25 !!!", e);
        }
        this.serverThread.interrupt();
    }

    @Override
    public int port() {
        return this.serverSocket.getLocalPort();
    }

    private void listen() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                Thread.ofVirtual().name("TCPServer-Handler-" + String.valueOf(socket.getRemoteSocketAddress())).start(() -> this.handle(socket));
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.ERROR, "\u670d\u52a1\u5668\u63a5\u53d7\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
                this.stop();
            }
        }
    }

    private void handle(Socket socket) {
        try {
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.startHandshake();
            }
            if (this.connectHandler == null) {
                throw new IllegalStateException("\u672a\u8bbe\u7f6e\u7528\u6237\u5904\u7406\u7a0b\u5e8f");
            }
            TCPSocket tcpSocket = new TCPSocket(socket);
            this.connectHandler.accept(tcpSocket);
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, "\u5904\u7406 Socket \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
            try {
                socket.close();
            }
            catch (IOException ex) {
                LOGGER.log(System.Logger.Level.ERROR, "\u5173\u95ed Socket \u53d1\u751f\u9519\u8bef", (Throwable)ex);
            }
        }
    }
}

