/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp.tls;

import cool.scx.tcp.tls.TLSHelper;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class TLS {
    private final SSLContext sslContext;
    private final SSLServerSocketFactory serverSocketFactory;
    private final SSLSocketFactory socketFactory;
    private boolean enabled = true;

    public TLS(Path path, String password) {
        KeyStore keyStore = TLSHelper.createKeyStore(path, password);
        KeyManagerFactory KeyManagerFactory2 = TLSHelper.createKeyManagerFactory(keyStore, password);
        TrustManagerFactory trustManagerFactory = TLSHelper.createTrustManagerFactory(keyStore);
        this.sslContext = TLSHelper.createSSLContext(KeyManagerFactory2, trustManagerFactory);
        this.serverSocketFactory = this.sslContext.getServerSocketFactory();
        this.socketFactory = this.sslContext.getSocketFactory();
    }

    public TLS(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.serverSocketFactory = sslContext.getServerSocketFactory();
        this.socketFactory = sslContext.getSocketFactory();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public TLS enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public ServerSocket createServerSocket() throws IOException {
        return this.serverSocketFactory.createServerSocket();
    }

    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }
}

