/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.ClassicTCPSocket;
import cool.scx.tcp.ScxTCPServer;
import cool.scx.tcp.ScxTCPServerOptions;
import cool.scx.tcp.ScxTCPSocket;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.function.Consumer;

public class ClassicTCPServer
implements ScxTCPServer {
    private static final System.Logger LOGGER = System.getLogger(ClassicTCPServer.class.getName());
    private final ScxTCPServerOptions options;
    private final Thread serverThread;
    private Consumer<ScxTCPSocket> connectHandler;
    private ServerSocket serverSocket;
    private boolean running;

    public ClassicTCPServer() {
        this(new ScxTCPServerOptions());
    }

    public ClassicTCPServer(ScxTCPServerOptions options) {
        this.options = options;
        this.serverThread = Thread.ofPlatform().name("ClassicTCPServer-Listener").unstarted(this::listen);
    }

    @Override
    public ScxTCPServer onConnect(Consumer<ScxTCPSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public void start() {
        if (this.running) {
            throw new IllegalStateException("\u670d\u52a1\u5668\u5df2\u5728\u8fd0\u884c !!!");
        }
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(this.options.localAddress(), this.options.backlog());
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u542f\u52a8\u670d\u52a1\u5668\u5931\u8d25 !!!", e);
        }
        this.running = true;
        this.serverThread.start();
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u5173\u95ed\u670d\u52a1\u5668\u5931\u8d25 !!!", e);
        }
        this.serverThread.interrupt();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    private void listen() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                Thread.ofVirtual().name("ClassicTCPServer-Handler-" + String.valueOf(socket.getRemoteSocketAddress())).start(() -> this.handle(socket));
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.ERROR, "\u670d\u52a1\u5668 \u63a5\u53d7\u8fde\u63a5 \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
                this.stop();
            }
        }
    }

    private void handle(Socket socket) {
        ClassicTCPSocket tcpSocket = new ClassicTCPSocket(socket);
        if (this.options.autoUpgradeToTLS()) {
            try {
                tcpSocket.upgradeToTLS(this.options.tls());
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.TRACE, "\u5347\u7ea7\u5230 TLS \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
                this.tryCloseSocket(tcpSocket);
                return;
            }
        }
        if (tcpSocket.tlsManager() != null) {
            tcpSocket.tlsManager().setUseClientMode(false);
        }
        if (this.options.autoHandshake()) {
            try {
                tcpSocket.startHandshake();
            }
            catch (IOException e) {
                LOGGER.log(System.Logger.Level.TRACE, "\u5904\u7406 TLS \u63e1\u624b \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
                this.tryCloseSocket(tcpSocket);
                return;
            }
        }
        if (this.connectHandler == null) {
            LOGGER.log(System.Logger.Level.ERROR, "\u672a\u8bbe\u7f6e \u8fde\u63a5\u5904\u7406\u5668, \u5173\u95ed\u8fde\u63a5 !!!");
            this.tryCloseSocket(tcpSocket);
            return;
        }
        try {
            this.connectHandler.accept(tcpSocket);
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, "\u8c03\u7528 \u8fde\u63a5\u5904\u7406\u5668 \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
            this.tryCloseSocket(tcpSocket);
        }
    }

    private void tryCloseSocket(ScxTCPSocket tcpSocket) {
        try {
            tcpSocket.close();
        }
        catch (IOException ex) {
            LOGGER.log(System.Logger.Level.TRACE, "\u5173\u95ed Socket \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)ex);
        }
    }
}

