/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.NioTCPSocket;
import cool.scx.tcp.ScxTCPClient;
import cool.scx.tcp.ScxTCPClientOptions;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.proxy.Proxy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;

public class NioTCPClient
implements ScxTCPClient {
    private final ScxTCPClientOptions options;

    public NioTCPClient() {
        this(new ScxTCPClientOptions());
    }

    public NioTCPClient(ScxTCPClientOptions options) {
        this.options = options;
    }

    @Override
    public ScxTCPSocket connect(SocketAddress endpoint) {
        SocketChannel socketChannel;
        Proxy proxy = this.options.proxy();
        try {
            socketChannel = SocketChannel.open();
            socketChannel.connect(endpoint);
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u5ba2\u6237\u7aef\u8fde\u63a5\u5931\u8d25 !!!", e);
        }
        NioTCPSocket tcpSocket = new NioTCPSocket(socketChannel);
        if (this.options.autoUpgradeToTLS()) {
            try {
                tcpSocket.upgradeToTLS(this.options.tls());
            }
            catch (IOException e) {
                this.tryCloseSocket(tcpSocket, e);
                throw new UncheckedIOException("\u5347\u7ea7\u5230 TLS \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
            }
        }
        if (tcpSocket.tlsManager() != null) {
            tcpSocket.tlsManager().setUseClientMode(true);
        }
        if (this.options.autoHandshake()) {
            try {
                tcpSocket.startHandshake();
            }
            catch (IOException e) {
                this.tryCloseSocket(tcpSocket, e);
                throw new UncheckedIOException("\u5904\u7406 TLS \u63e1\u624b \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
            }
        }
        return tcpSocket;
    }

    private void tryCloseSocket(ScxTCPSocket tcpSocket, Exception e) {
        try {
            tcpSocket.close();
        }
        catch (IOException ex) {
            e.addSuppressed(ex);
        }
    }
}

