/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.NioTLSManager;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.ScxTLSManager;
import cool.scx.tcp.tls.TLS;
import cool.scx.tcp.tls_channel.TLSSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;

public class NioTCPSocket
implements ScxTCPSocket {
    private SocketChannel socketChannel;
    private InputStream in;
    private OutputStream out;
    private ScxTLSManager tlsManager;

    public NioTCPSocket(SocketChannel socketChannel) {
        this.setSocket(socketChannel);
    }

    @Override
    public InputStream inputStream() {
        return this.in;
    }

    @Override
    public OutputStream outputStream() {
        return this.out;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        try {
            return (InetSocketAddress)this.socketChannel.getRemoteAddress();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public InetSocketAddress localAddress() {
        try {
            return (InetSocketAddress)this.socketChannel.getLocalAddress();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public ScxTCPSocket upgradeToTLS(TLS tls) throws IOException {
        if (tls != null && tls.enabled()) {
            TLSSocketChannel sslSocket = new TLSSocketChannel(this.socketChannel, tls.sslContext().createSSLEngine());
            this.setSocket(sslSocket);
        }
        return this;
    }

    @Override
    public boolean isTLS() {
        return this.socketChannel instanceof TLSSocketChannel;
    }

    @Override
    public ScxTCPSocket startHandshake() throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel instanceof TLSSocketChannel) {
            TLSSocketChannel tlsSocketChannel = (TLSSocketChannel)socketChannel;
            tlsSocketChannel.startHandshake();
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return !this.socketChannel.isOpen();
    }

    @Override
    public ScxTLSManager tlsManager() {
        return this.tlsManager;
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.close();
    }

    private void setSocket(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        this.in = Channels.newInputStream(socketChannel);
        this.out = Channels.newOutputStream(socketChannel);
        if (socketChannel instanceof TLSSocketChannel) {
            TLSSocketChannel tlsSocketChannel = (TLSSocketChannel)socketChannel;
            this.tlsManager = new NioTLSManager(tlsSocketChannel.sslEngine());
        }
    }
}

