/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.tls.TLS;
import java.net.InetSocketAddress;

public class ScxTCPServerOptions {
    private InetSocketAddress localAddress;
    private int backlog;
    private TLS tls;
    private boolean autoUpgradeToTLS;
    private boolean autoHandshake;

    public ScxTCPServerOptions() {
        this.localAddress = new InetSocketAddress(0);
        this.backlog = 128;
        this.tls = null;
        this.autoUpgradeToTLS = true;
        this.autoHandshake = true;
    }

    public ScxTCPServerOptions(ScxTCPServerOptions oldOptions) {
        this.localAddress(oldOptions.localAddress());
        this.backlog(oldOptions.backlog());
        this.tls(oldOptions.tls());
        this.autoUpgradeToTLS(oldOptions.autoUpgradeToTLS());
        this.autoHandshake(oldOptions.autoHandshake());
    }

    public InetSocketAddress localAddress() {
        return this.localAddress;
    }

    public ScxTCPServerOptions localAddress(InetSocketAddress localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public int backlog() {
        return this.backlog;
    }

    public ScxTCPServerOptions backlog(int backlog) {
        this.backlog = backlog;
        return this;
    }

    public TLS tls() {
        return this.tls;
    }

    public ScxTCPServerOptions tls(TLS tls) {
        this.tls = tls;
        return this;
    }

    public boolean autoUpgradeToTLS() {
        return this.autoUpgradeToTLS;
    }

    public ScxTCPServerOptions autoUpgradeToTLS(boolean autoUpgradeToTLS) {
        this.autoUpgradeToTLS = autoUpgradeToTLS;
        return this;
    }

    public boolean autoHandshake() {
        return this.autoHandshake;
    }

    public ScxTCPServerOptions autoHandshake(boolean autoHandshake) {
        this.autoHandshake = autoHandshake;
        return this;
    }

    public ScxTCPServerOptions port(int port) {
        return this.localAddress(new InetSocketAddress(port));
    }
}

