/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp.tls;

import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.Base64Utils;
import cool.scx.tcp.tls.PemObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PemHelper {
    public static final Pattern PEM_PATTERN = Pattern.compile("-----BEGIN (.+?)-----([\\s\\S]+?)-----END \\1-----");

    public static PemObject parsePem(String pemContent) throws IllegalArgumentException {
        Matcher matcher = PEM_PATTERN.matcher(pemContent.trim());
        if (matcher.find()) {
            String marker = matcher.group(1);
            String base64Content = matcher.group(2).replaceAll("\\s", "");
            byte[] content = Base64Utils.decode((String)base64Content);
            return new PemObject(content, marker);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790 PEM \u5185\u5bb9\uff1a\u672a\u627e\u5230\u6709\u6548\u7684\u6807\u8bb0");
    }

    public static byte[] convertPKCS1ToPKCS8(byte[] pkcs1Bytes) {
        byte[] pkcs8Header = new byte[]{48, -126, 0, 0, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 0, 0};
        int pkcs1Length = pkcs1Bytes.length;
        int totalLength = pkcs1Length + pkcs8Header.length - 4;
        pkcs8Header[2] = (byte)(totalLength >> 8 & 0xFF);
        pkcs8Header[3] = (byte)(totalLength & 0xFF);
        pkcs8Header[pkcs8Header.length - 2] = (byte)(pkcs1Length >> 8 & 0xFF);
        pkcs8Header[pkcs8Header.length - 1] = (byte)(pkcs1Length & 0xFF);
        return ArrayUtils.concat((byte[])pkcs8Header, (byte[])pkcs1Bytes);
    }
}

