/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp.tls;

import cool.scx.tcp.tls.TLSHelper;
import cool.scx.tcp.tls.TLSImpl;
import java.nio.file.Path;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public interface TLS {
    public static TLS of(Path path, String password) {
        return new TLSImpl(TLSHelper.createSSLContext(path, password));
    }

    public static TLS of(SSLContext sslContext) {
        return new TLSImpl(sslContext);
    }

    public static TLS ofPem(Path pemPath, Path keyPath) {
        return new TLSImpl(TLSHelper.createSSLContextFromPem(pemPath, keyPath));
    }

    public static TLS ofPem(String pemContent, String keyContent) {
        return new TLSImpl(TLSHelper.createSSLContextFromPem(pemContent, keyContent));
    }

    public static TLS ofDefault() {
        return new TLSImpl(TLSHelper.createDefaultSSLContext());
    }

    public static TLS ofTrustAny() {
        return new TLSImpl(TLSHelper.createTrustAnySSLContext());
    }

    public boolean enabled();

    public TLS enabled(boolean var1);

    public SSLContext sslContext();

    public SSLServerSocketFactory serverSocketFactory();

    public SSLSocketFactory socketFactory();
}

