/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp.tls_channel;

import cool.scx.io.IOHelper;
import cool.scx.tcp.tls_channel.AbstractSocketChannel;
import cool.scx.tcp.tls_channel.UnwrapResult;
import cool.scx.tcp.tls_channel.WrapResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;

public class TLSSocketChannel
extends AbstractSocketChannel {
    private final SSLEngine sslEngine;
    private ByteBuffer outboundNetData;
    private ByteBuffer inboundNetData;
    private ByteBuffer inboundAppData;

    public TLSSocketChannel(SocketChannel socketChannel, SSLEngine sslEngine) {
        super(socketChannel);
        this.sslEngine = sslEngine;
        SSLSession session = sslEngine.getSession();
        int packetBufferSize = session.getPacketBufferSize();
        int applicationBufferSize = session.getApplicationBufferSize();
        this.outboundNetData = ByteBuffer.allocate(packetBufferSize);
        this.inboundNetData = ByteBuffer.allocate(packetBufferSize);
        this.inboundAppData = ByteBuffer.allocate(applicationBufferSize).flip();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startHandshake() throws IOException {
        this.sslEngine.beginHandshake();
        while (true) {
            block19: {
                Runnable task;
                SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        Object result = this.unwrap(false);
                        switch (((UnwrapResult)result).status) {
                            case SOCKET_CHANNEL_CLOSED: {
                                throw new SSLHandshakeException("Channel closed during handshake");
                            }
                            case CLOSED: {
                                throw new SSLHandshakeException("closed on handshake wrap");
                            }
                        }
                        break block19;
                    }
                    case NEED_WRAP: {
                        Object result = this.wrap(ByteBuffer.allocate(0));
                        switch (((WrapResult)result).status) {
                            case OK: {
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                throw new SSLHandshakeException("BUFFER_OVERFLOW on handshake wrap");
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLHandshakeException("BUFFER_UNDERFLOW on handshake wrap");
                            }
                            case CLOSED: {
                                throw new SSLHandshakeException("CLOSED on handshake wrap");
                            }
                        }
                        break block19;
                    }
                    case NEED_TASK: {
                        break;
                    }
                    case FINISHED: {
                        return;
                    }
                    case NOT_HANDSHAKING: {
                        return;
                    }
                }
                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                    task.run();
                }
            }
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.inboundAppData.hasRemaining()) {
            return IOHelper.transferByteBuffer((ByteBuffer)this.inboundAppData, (ByteBuffer)dst);
        }
        this.inboundAppData.clear();
        UnwrapResult result = this.unwrap(true);
        this.inboundAppData.flip();
        switch (result.status) {
            case SOCKET_CHANNEL_CLOSED: {
                return -1;
            }
            case CLOSED: {
                this.sslEngine.closeInbound();
            }
        }
        return IOHelper.transferByteBuffer((ByteBuffer)this.inboundAppData, (ByteBuffer)dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        WrapResult result = this.wrap(src);
        switch (result.status) {
            case BUFFER_OVERFLOW: {
                throw new SSLException("BUFFER_OVERFLOW on handshake wrap");
            }
            case BUFFER_UNDERFLOW: {
                throw new SSLException("BUFFER_UNDERFLOW on handshake wrap");
            }
            case CLOSED: {
                throw new SSLException("CLOSED on handshake wrap");
            }
        }
        return result.bytesConsumed;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.sslEngine.closeOutbound();
        while (!this.sslEngine.isOutboundDone()) {
            this.wrap(ByteBuffer.allocate(0));
        }
        this.inboundAppData.clear();
        this.unwrap(true);
        this.socketChannel.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    public WrapResult wrap(ByteBuffer src) throws IOException {
        WrapResult wrapResult = new WrapResult();
        while (true) {
            this.outboundNetData.clear();
            SSLEngineResult result = this.sslEngine.wrap(src, this.outboundNetData);
            wrapResult.bytesConsumed += result.bytesConsumed();
            wrapResult.bytesProduced += result.bytesProduced();
            wrapResult.status = result.getStatus();
            switch (result.getStatus()) {
                case OK: {
                    this.outboundNetData.flip();
                    while (this.outboundNetData.hasRemaining()) {
                        this.socketChannel.write(this.outboundNetData);
                    }
                    if (!src.hasRemaining()) {
                        return wrapResult;
                    }
                    break;
                }
                case BUFFER_OVERFLOW: {
                    this.outboundNetData = ByteBuffer.allocate(this.outboundNetData.capacity() * 2);
                    break;
                }
                case BUFFER_UNDERFLOW: {
                    return wrapResult;
                }
                case CLOSED: {
                    this.outboundNetData.flip();
                    while (this.outboundNetData.hasRemaining()) {
                        this.socketChannel.write(this.outboundNetData);
                    }
                    return wrapResult;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public UnwrapResult unwrap(boolean forceRead) throws IOException {
        boolean needRead;
        UnwrapResult unwrapResult = new UnwrapResult();
        boolean bl = needRead = forceRead || this.inboundNetData.position() == 0;
        block6: while (true) {
            int bytesRead;
            if (needRead && (bytesRead = this.socketChannel.read(this.inboundNetData)) == -1) {
                unwrapResult.status = UnwrapResult.Status.SOCKET_CHANNEL_CLOSED;
                return unwrapResult;
            }
            this.inboundNetData.flip();
            while (this.inboundNetData.hasRemaining()) {
                SSLEngineResult result = this.sslEngine.unwrap(this.inboundNetData, this.inboundAppData);
                unwrapResult.bytesConsumed += result.bytesConsumed();
                unwrapResult.bytesProduced += result.bytesProduced();
                switch (result.getStatus()) {
                    case OK: {
                        unwrapResult.status = UnwrapResult.Status.OK;
                        if (result.bytesProduced() != 0 || result.bytesConsumed() != 0) break;
                        break block6;
                    }
                    case BUFFER_OVERFLOW: {
                        unwrapResult.status = UnwrapResult.Status.BUFFER_OVERFLOW;
                        ByteBuffer newAppBuffer = ByteBuffer.allocate(this.inboundAppData.capacity() * 2);
                        newAppBuffer.put(this.inboundAppData.flip());
                        this.inboundAppData = newAppBuffer;
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        boolean isFull;
                        unwrapResult.status = UnwrapResult.Status.BUFFER_UNDERFLOW;
                        if (unwrapResult.bytesProduced > 0) break block6;
                        boolean bl2 = isFull = this.inboundNetData.limit() == this.inboundNetData.capacity();
                        if (isFull) {
                            ByteBuffer newInboundNetData = ByteBuffer.allocate(this.inboundNetData.capacity() * 2);
                            newInboundNetData.put(this.inboundNetData);
                            this.inboundNetData = newInboundNetData;
                        } else {
                            this.inboundNetData.position(this.inboundNetData.limit());
                            this.inboundNetData.limit(this.inboundNetData.capacity());
                        }
                        needRead = true;
                        continue block6;
                    }
                    case CLOSED: {
                        unwrapResult.status = UnwrapResult.Status.CLOSED;
                        break block6;
                    }
                }
            }
            break;
        }
        this.inboundNetData.compact();
        return unwrapResult;
    }

    public SSLEngine sslEngine() {
        return this.sslEngine;
    }
}

