/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp.tls_channel;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Set;

public abstract class AbstractSocketChannel
extends SocketChannel {
    protected final SocketChannel socketChannel;

    public AbstractSocketChannel(SocketChannel socketChannel) {
        super(socketChannel.provider());
        this.socketChannel = socketChannel;
    }

    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        this.socketChannel.bind(local);
        return this;
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.socketChannel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.socketChannel.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.socketChannel.supportedOptions();
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        this.socketChannel.shutdownInput();
        return this;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        this.socketChannel.shutdownOutput();
        return this;
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.socketChannel.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        return this.socketChannel.connect(remote);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.socketChannel.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socketChannel.getLocalAddress();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.socketChannel.configureBlocking(block);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long n = 0L;
        for (int i = offset; i < length; ++i) {
            n += (long)this.read(dsts[i]);
        }
        return n;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long n = 0L;
        for (int i = offset; i < length; ++i) {
            n += (long)this.write(srcs[i]);
        }
        return n;
    }
}

