/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.ClassicTCPSocket;
import cool.scx.tcp.ScxTCPClient;
import cool.scx.tcp.ScxTCPClientOptions;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.proxy.Proxy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketAddress;

public class ClassicTCPClient
implements ScxTCPClient {
    private final ScxTCPClientOptions options;

    public ClassicTCPClient() {
        this(new ScxTCPClientOptions());
    }

    public ClassicTCPClient(ScxTCPClientOptions options) {
        this.options = options;
    }

    @Override
    public ScxTCPSocket connect(SocketAddress endpoint) {
        Socket socket;
        Proxy proxy = this.options.proxy();
        try {
            socket = new Socket();
            socket.connect(endpoint);
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u5ba2\u6237\u7aef\u8fde\u63a5\u5931\u8d25 !!!", e);
        }
        ClassicTCPSocket tcpSocket = new ClassicTCPSocket(socket);
        if (this.options.autoUpgradeToTLS()) {
            try {
                tcpSocket.upgradeToTLS(this.options.tls());
            }
            catch (IOException e) {
                this.tryCloseSocket(tcpSocket, e);
                throw new UncheckedIOException("\u5347\u7ea7\u5230 TLS \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
            }
        }
        if (tcpSocket.tlsManager() != null) {
            tcpSocket.tlsManager().setUseClientMode(true);
        }
        if (this.options.autoHandshake()) {
            try {
                tcpSocket.startHandshake();
            }
            catch (IOException e) {
                this.tryCloseSocket(tcpSocket, e);
                throw new UncheckedIOException("\u5904\u7406 TLS \u63e1\u624b \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
            }
        }
        return tcpSocket;
    }

    private void tryCloseSocket(ScxTCPSocket tcpSocket, Exception e) {
        try {
            tcpSocket.close();
        }
        catch (IOException ex) {
            e.addSuppressed(ex);
        }
    }
}

