/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.ScxTLSManager;
import cool.scx.tcp.TLSManager;
import cool.scx.tcp.tls.TLS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;

public class TCPSocket
implements ScxTCPSocket {
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private ScxTLSManager tlsManager;

    public TCPSocket(Socket socket) {
        this.setSocket(socket);
    }

    @Override
    public InputStream inputStream() {
        return this.in;
    }

    @Override
    public OutputStream outputStream() {
        return this.out;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    public TCPSocket upgradeToTLS(TLS tls) throws IOException {
        if (tls != null && tls.enabled()) {
            Socket sslSocket = tls.socketFactory().createSocket(this.socket, null, -1, true);
            this.setSocket(sslSocket);
        }
        return this;
    }

    @Override
    public boolean isTLS() {
        return this.socket instanceof SSLSocket;
    }

    @Override
    public ScxTCPSocket startHandshake() throws IOException {
        Socket socket = this.socket;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.startHandshake();
        }
        return this;
    }

    @Override
    public ScxTLSManager tlsManager() {
        return this.tlsManager;
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    private void setSocket(Socket socket) {
        this.socket = socket;
        try {
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            this.tlsManager = new TLSManager(sslSocket);
        }
    }
}

