/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp.tls;

import cool.scx.common.util.RandomUtils;
import cool.scx.tcp.tls.PemHelper;
import cool.scx.tcp.tls.PemObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class TLSHelper {
    public static KeyStore createKeyStore(Path path, String password) {
        try {
            return KeyStore.getInstance(path.toFile(), password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException("failed to create keystore ", e);
        }
    }

    public static KeyStore createKeyStore(X509Certificate certificate, PrivateKey privateKey, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, null);
            if (privateKey != null) {
                keyStore.setKeyEntry("default", privateKey, password.toCharArray(), new Certificate[]{certificate});
            } else {
                keyStore.setCertificateEntry("default", certificate);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to create keystore ", e);
        }
    }

    public static X509Certificate createCertificateFromPem(String pemContent) {
        PemObject certPemObject = PemHelper.parsePem(pemContent);
        if (!"CERTIFICATE".equals(certPemObject.marker())) {
            throw new IllegalArgumentException("PEM \u5185\u5bb9\u4e0d\u662f\u8bc1\u4e66");
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certPemObject.content()));
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey createPrivateKeyFromPem(String pemContent) {
        PemObject keyPemObject = PemHelper.parsePem(pemContent);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(switch (keyPemObject.marker()) {
            case "PRIVATE KEY" -> keyPemObject.content();
            case "RSA PRIVATE KEY" -> PemHelper.convertPKCS1ToPKCS8(keyPemObject.content());
            default -> throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u79c1\u94a5\u683c\u5f0f: " + keyPemObject.marker());
        });
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyManagerFactory createKeyManagerFactory(KeyStore keyStore, String password) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
            keyManagerFactory.init(keyStore, password.toCharArray());
            return keyManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException("failed to create key manager factory");
        }
    }

    public static TrustManagerFactory createTrustManagerFactory(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(keyStore);
            return trustManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("failed to create key manager factory");
        }
    }

    public static SSLContext createSSLContext(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("failed to create ssl context", e);
        }
    }

    public static SSLContext createSSLContext(Path path, String password) {
        KeyStore keyStore = TLSHelper.createKeyStore(path, password);
        return TLSHelper.createSSLContext(keyStore, password);
    }

    public static SSLContext createSSLContext(KeyStore keyStore, String password) {
        KeyManagerFactory KeyManagerFactory2 = TLSHelper.createKeyManagerFactory(keyStore, password);
        TrustManagerFactory trustManagerFactory = TLSHelper.createTrustManagerFactory(keyStore);
        return TLSHelper.createSSLContext(KeyManagerFactory2, trustManagerFactory);
    }

    public static SSLContext createSSLContextFromPem(Path certPemPath, Path keyPemPath) {
        try {
            String certPemContent = Files.readString(certPemPath);
            String keyPemContent = keyPemPath != null ? Files.readString(keyPemPath) : null;
            return TLSHelper.createSSLContextFromPem(certPemContent, keyPemContent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext createSSLContextFromPem(String certPemContent, String keyPemContent) {
        return TLSHelper.createSSLContextFromPem(certPemContent, keyPemContent, RandomUtils.randomString((int)6));
    }

    public static SSLContext createSSLContextFromPem(String certPemContent, String keyPemContent, String keyPassword) {
        X509Certificate certificate = TLSHelper.createCertificateFromPem(certPemContent);
        PrivateKey privateKey = keyPemContent != null ? TLSHelper.createPrivateKeyFromPem(keyPemContent) : null;
        KeyStore keyStore = TLSHelper.createKeyStore(certificate, privateKey, keyPassword);
        return TLSHelper.createSSLContext(keyStore, keyPassword);
    }

    public static SSLContext createDefaultSSLContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to initialize default TLS configuration", e);
        }
    }

    public static SSLContext createTrustAnySSLContext() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

