/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp;

import cool.scx.function.ConsumerX;
import cool.scx.tcp.ScxTCPServer;
import cool.scx.tcp.ScxTCPSocket;
import cool.scx.tcp.TCPServerOptions;
import cool.scx.tcp.TCPSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;

public final class TCPServer
implements ScxTCPServer {
    private static final System.Logger LOGGER = System.getLogger(TCPServer.class.getName());
    private final TCPServerOptions options;
    private final Thread serverThread;
    private ConsumerX<ScxTCPSocket, ?> connectHandler;
    private ServerSocket serverSocket;
    private volatile boolean running;

    public TCPServer() {
        this(new TCPServerOptions());
    }

    public TCPServer(TCPServerOptions options) {
        this.options = options;
        this.serverThread = Thread.ofPlatform().name("TCPServer-Listener").unstarted(this::listen);
        this.running = false;
    }

    @Override
    public ScxTCPServer onConnect(ConsumerX<ScxTCPSocket, ?> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public void start(SocketAddress localAddress) throws IOException {
        if (this.running) {
            throw new IllegalStateException("\u670d\u52a1\u5668\u5df2\u5728\u8fd0\u884c !!!");
        }
        if (this.connectHandler == null) {
            throw new IllegalStateException("\u672a\u8bbe\u7f6e \u8fde\u63a5\u5904\u7406\u5668 !!!");
        }
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(localAddress, this.options.backlog());
        this.running = true;
        this.serverThread.start();
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.TRACE, "\u5173\u95ed ServerSocket \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
        }
        try {
            this.serverThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    public TCPServerOptions options() {
        return this.options;
    }

    private void listen() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                Thread.ofVirtual().name("TCPServer-Handler-" + String.valueOf(socket.getRemoteSocketAddress())).start(() -> this.handle(socket));
            }
            catch (IOException e) {
                if (!this.running) break;
                this.running = false;
                LOGGER.log(System.Logger.Level.ERROR, "\u670d\u52a1\u5668 \u63a5\u53d7\u8fde\u63a5 \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
                try {
                    this.serverSocket.close();
                }
                catch (IOException ex) {
                    LOGGER.log(System.Logger.Level.TRACE, "\u5173\u95ed ServerSocket \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)ex);
                }
                break;
            }
        }
    }

    private void handle(Socket socket) {
        TCPSocket tcpSocket;
        try {
            tcpSocket = new TCPSocket(socket);
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "\u521b\u5efa TCPSocket \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)e);
            this.tryCloseSocket(socket);
            return;
        }
        try {
            this.connectHandler.accept((Object)tcpSocket);
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, "\u8c03\u7528 \u8fde\u63a5\u5904\u7406\u5668 \u65f6\u53d1\u751f\u9519\u8bef !!!", e);
            this.tryCloseSocket(tcpSocket);
        }
    }

    private void tryCloseSocket(ScxTCPSocket tcpSocket) {
        try {
            tcpSocket.close();
        }
        catch (IOException ex) {
            LOGGER.log(System.Logger.Level.TRACE, "\u5173\u95ed TCPSocket \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)ex);
        }
    }

    private void tryCloseSocket(Socket tcpSocket) {
        try {
            tcpSocket.close();
        }
        catch (IOException ex) {
            LOGGER.log(System.Logger.Level.TRACE, "\u5173\u95ed Socket \u65f6\u53d1\u751f\u9519\u8bef !!!", (Throwable)ex);
        }
    }
}

