/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.tcp.tls;

import cool.scx.tcp.tls.TLSHelper;
import cool.scx.tcp.tls.TLSImpl;
import java.nio.file.Path;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public interface TLS {
    public static TLS of(SSLContext sslContext) {
        return new TLSImpl(sslContext);
    }

    public static TLS of(Path path, String password) {
        return new TLSImpl(TLSHelper.createSSLContext(path, password));
    }

    public static TLS ofDefault() {
        return new TLSImpl(TLSHelper.createDefaultSSLContext());
    }

    public static TLS ofTrustAny() {
        return new TLSImpl(TLSHelper.createTrustAnySSLContext());
    }

    public SSLContext sslContext();

    public SSLServerSocketFactory serverSocketFactory();

    public SSLSocketFactory socketFactory();
}

