/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.timer;

import cool.scx.functional.ScxCallable;
import cool.scx.functional.ScxRunnable;
import cool.scx.timer.ScxTimer;
import cool.scx.timer.TaskHandle;
import cool.scx.timer.TaskStatus;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ScheduledExecutorTimer
implements ScxTimer {
    private final ScheduledExecutorService executor;

    public ScheduledExecutorTimer(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public <E extends Throwable> TaskHandle<Void, E> runAfter(ScxRunnable<E> action, long delay, TimeUnit unit) {
        AtomicReference<TaskStatus> taskStatus = new AtomicReference<TaskStatus>(TaskStatus.PENDING);
        ScheduledFuture<?> future = this.executor.schedule(() -> {
            taskStatus.set(TaskStatus.RUNNING);
            try {
                action.run();
                taskStatus.set(TaskStatus.SUCCESS);
            }
            catch (Throwable e) {
                taskStatus.set(TaskStatus.FAILED);
                throw new WrapperRuntimeException(e);
            }
        }, delay, unit);
        return new TaskHandleImpl(future, taskStatus);
    }

    @Override
    public <V, E extends Throwable> TaskHandle<V, E> runAfter(ScxCallable<V, E> action, long delay, TimeUnit unit) {
        AtomicReference<TaskStatus> taskStatus = new AtomicReference<TaskStatus>(TaskStatus.PENDING);
        ScheduledFuture<Object> future = this.executor.schedule(() -> {
            taskStatus.set(TaskStatus.RUNNING);
            try {
                Object result = action.call();
                taskStatus.set(TaskStatus.SUCCESS);
                return result;
            }
            catch (Throwable e) {
                taskStatus.set(TaskStatus.FAILED);
                throw new WrapperRuntimeException(e);
            }
        }, delay, unit);
        return new TaskHandleImpl(future, taskStatus);
    }

    private record TaskHandleImpl<V, E extends Throwable>(ScheduledFuture<?> future, AtomicReference<TaskStatus> taskStatus) implements TaskHandle<V, E>
    {
        @Override
        public boolean cancel() {
            return this.future.cancel(false);
        }

        @Override
        public V await() throws E {
            try {
                return this.future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Task was interrupted", e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof WrapperRuntimeException) {
                    cause = cause.getCause();
                }
                throw cause;
            }
            catch (CancellationException e) {
                throw new IllegalStateException("Task was cancelled", e);
            }
        }

        @Override
        public TaskStatus status() {
            if (this.future.isDone()) {
                TaskStatus status = this.taskStatus.get();
                if (status == TaskStatus.PENDING && this.future.isCancelled()) {
                    return TaskStatus.CANCELLED;
                }
                return status;
            }
            TaskStatus status = this.taskStatus.get();
            if (status == TaskStatus.PENDING) {
                return TaskStatus.PENDING;
            }
            return TaskStatus.RUNNING;
        }

        @Override
        public V result() {
            return this.future.resultNow();
        }

        @Override
        public E exception() {
            Throwable e = this.future.exceptionNow();
            if (e instanceof WrapperRuntimeException) {
                e = e.getCause();
            }
            return (E)e;
        }
    }

    private static class WrapperRuntimeException
    extends RuntimeException {
        public WrapperRuntimeException(Throwable cause) {
            super(cause);
        }
    }
}

