/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.standard.HttpFieldName;
import cool.scx.common.standard.MediaType;
import cool.scx.common.util.JsonNodeHelper;
import cool.scx.common.util.ObjectUtils;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class ScxWebHelper {
    public static Object getFromMap(String name, MultiMap map, boolean useAll, JavaType javaType) {
        if (useAll) {
            return map;
        }
        if (javaType.isCollectionLikeType() || javaType.isArrayType()) {
            return map.getAll(name);
        }
        return map.get(name);
    }

    public static Object getFromMap(String name, Map<String, String> map, boolean useAll) {
        return useAll ? map : map.get(name);
    }

    public static <T> T readValue(JsonNode jsonNode, JavaType type) throws IOException {
        return (T)ObjectUtils.jsonMapper((ObjectUtils.Options)new ObjectUtils.Options().setIgnoreJsonIgnore(true)).readerFor(type).readValue(jsonNode);
    }

    public static JsonNode getFromJsonNode(String name, JsonNode jsonNode, boolean useAll) {
        return useAll ? jsonNode : JsonNodeHelper.get((JsonNode)jsonNode, (String)name);
    }

    public static boolean responseCanUse(RoutingContext context) {
        return !context.request().response().ended() && !context.request().response().closed();
    }

    public static HttpMethod toVertxMethod(cool.scx.common.standard.HttpMethod httpMethod) {
        return switch (httpMethod) {
            default -> throw new MatchException(null, null);
            case cool.scx.common.standard.HttpMethod.CONNECT -> HttpMethod.CONNECT;
            case cool.scx.common.standard.HttpMethod.DELETE -> HttpMethod.DELETE;
            case cool.scx.common.standard.HttpMethod.GET -> HttpMethod.GET;
            case cool.scx.common.standard.HttpMethod.HEAD -> HttpMethod.HEAD;
            case cool.scx.common.standard.HttpMethod.OPTIONS -> HttpMethod.OPTIONS;
            case cool.scx.common.standard.HttpMethod.PATCH -> HttpMethod.PATCH;
            case cool.scx.common.standard.HttpMethod.POST -> HttpMethod.POST;
            case cool.scx.common.standard.HttpMethod.PUT -> HttpMethod.PUT;
            case cool.scx.common.standard.HttpMethod.TRACE -> HttpMethod.TRACE;
        };
    }

    public static HttpServerResponse fillContentType(HttpServerResponse response, MediaType contentType) {
        if (contentType != null) {
            if (contentType.type().equals("text")) {
                return response.putHeader(HttpFieldName.CONTENT_TYPE.toString(), contentType.toString(StandardCharsets.UTF_8));
            }
            return response.putHeader(HttpFieldName.CONTENT_TYPE.toString(), contentType.toString());
        }
        return response.putHeader(HttpFieldName.CONTENT_TYPE.toString(), MediaType.APPLICATION_OCTET_STREAM.toString());
    }

    public static HttpServerResponse fillJsonContentType(HttpServerResponse response) {
        return response.putHeader(HttpFieldName.CONTENT_TYPE.toString(), MediaType.APPLICATION_JSON.toString(StandardCharsets.UTF_8));
    }

    public static HttpServerResponse fillXmlContentType(HttpServerResponse response) {
        return response.putHeader(HttpFieldName.CONTENT_TYPE.toString(), MediaType.APPLICATION_XML.toString(StandardCharsets.UTF_8));
    }

    public static HttpServerResponse fillHtmlContentType(HttpServerResponse response) {
        return response.putHeader(HttpFieldName.CONTENT_TYPE.toString(), MediaType.TEXT_HTML.toString(StandardCharsets.UTF_8));
    }

    public static HttpServerResponse fillTextPlainContentType(HttpServerResponse response) {
        return response.putHeader(HttpFieldName.CONTENT_TYPE.toString(), MediaType.TEXT_PLAIN.toString(StandardCharsets.UTF_8));
    }
}

