/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.parameter_handler;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.reflect.ParameterInfo;
import cool.scx.common.util.AnnotationUtils;
import cool.scx.common.util.ObjectUtils;
import cool.scx.web.ScxWebHelper;
import cool.scx.web.annotation.FromBody;
import cool.scx.web.parameter_handler.ParameterHandler;
import cool.scx.web.parameter_handler.RequestInfo;
import cool.scx.web.parameter_handler.exception.ParamConvertException;
import cool.scx.web.parameter_handler.exception.RequiredParamEmptyException;

public final class FromBodyParameterHandler
implements ParameterHandler {
    public static Object getValueFromBody(String name, boolean useAllBody, boolean required, JavaType javaType, RequestInfo info) throws RequiredParamEmptyException, ParamConvertException {
        if (info.contentType() == RequestInfo.ContentType.FORM) {
            return FromBodyParameterHandler.fromFormAttributes(name, useAllBody, required, javaType, info);
        }
        return FromBodyParameterHandler.fromBody(name, useAllBody, required, javaType, info);
    }

    private static Object fromBody(String name, boolean useAllBody, boolean required, JavaType javaType, RequestInfo info) throws RequiredParamEmptyException, ParamConvertException {
        Object o;
        JsonNode tempValue = ScxWebHelper.getFromJsonNode(name, info.body(), useAllBody);
        if (tempValue == null || tempValue.isNull() || tempValue.isMissingNode()) {
            if (required) {
                throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
            }
            return null;
        }
        try {
            o = ScxWebHelper.readValue(tempValue, javaType);
        }
        catch (Exception e) {
            throw new ParamConvertException("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38 !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "] , \u8be6\u7ec6\u9519\u8bef\u4fe1\u606f : " + e.getMessage());
        }
        if (o == null && required) {
            throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
        }
        return o;
    }

    private static Object fromFormAttributes(String name, boolean useAllBody, boolean required, JavaType javaType, RequestInfo info) throws RequiredParamEmptyException, ParamConvertException {
        Object o;
        Object tempValue = ScxWebHelper.getFromMap(name, info.routingContext().request().formAttributes(), useAllBody, javaType);
        if (tempValue == null) {
            if (required) {
                throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
            }
            return null;
        }
        try {
            o = ObjectUtils.convertValue((Object)tempValue, (JavaType)javaType, (ObjectUtils.Options)new ObjectUtils.Options().setIgnoreJsonIgnore(true));
        }
        catch (Exception e) {
            throw new ParamConvertException("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38 !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "] , \u8be6\u7ec6\u9519\u8bef\u4fe1\u606f : " + e.getMessage());
        }
        if (o == null && required) {
            throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromBody, useAllBody=" + useAllBody + "] , \u53c2\u6570\u7c7b\u578b [" + javaType.getTypeName() + "]");
        }
        return o;
    }

    @Override
    public boolean canHandle(ParameterInfo parameter) {
        return parameter.parameter().getAnnotation(FromBody.class) != null;
    }

    @Override
    public Object handle(ParameterInfo parameter, RequestInfo requestInfo) throws Exception {
        FromBody fromBody = parameter.parameter().getAnnotation(FromBody.class);
        if (fromBody == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u6ca1\u6709 FromBody \u6ce8\u89e3 !!!");
        }
        String value = AnnotationUtils.getAnnotationValue((String)fromBody.value());
        return FromBodyParameterHandler.getValueFromBody(value != null ? value : parameter.name(), fromBody.useAllBody(), fromBody.required(), parameter.type(), requestInfo);
    }
}

