/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.vo;

import cool.scx.web.ScxWebHelper;
import cool.scx.web.vo.BaseVo;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.file.Path;

public final class Html
implements BaseVo {
    private final boolean usePath;
    private final Path htmlPath;
    private final String htmlStr;

    private Html(Path htmlPath, String htmlStr, boolean usePath) {
        this.htmlPath = htmlPath;
        this.htmlStr = htmlStr;
        this.usePath = usePath;
    }

    public static Html of(String htmlStr) {
        return new Html(null, htmlStr, false);
    }

    public static Html of(Path htmlPath) throws IOException {
        return new Html(htmlPath, null, true);
    }

    public void accept(RoutingContext context) throws Exception {
        if (this.usePath) {
            this.sendHtmlPath(context);
        } else {
            this.sendHtmlStr(context);
        }
    }

    public void sendHtmlStr(RoutingContext context) {
        ScxWebHelper.fillHtmlContentType(context.request().response()).end(this.htmlStr);
    }

    public void sendHtmlPath(RoutingContext context) {
        ScxWebHelper.fillHtmlContentType(context.request().response()).sendFile(this.htmlPath.toString());
    }
}

