/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.websocket;

import cool.scx.web.websocket.WebSocketRoute;
import cool.scx.web.websocket.WebSocketRoutingContext;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.util.List;

public class OnFrameRoutingContext
extends WebSocketRoutingContext {
    private static final System.Logger logger = System.getLogger(OnFrameRoutingContext.class.getName());
    private final WebSocketFrame frame;

    OnFrameRoutingContext(WebSocketFrame frame, ServerWebSocket webSocket, List<WebSocketRoute> routes) {
        super(webSocket, routes);
        this.frame = frame;
    }

    public WebSocketFrame frame() {
        return this.frame;
    }

    public String textData() {
        return this.frame.textData();
    }

    public Buffer binaryData() {
        return this.frame.binaryData();
    }

    public void handle(WebSocketRoute next) {
        if (this.frame.isText()) {
            try {
                next.baseWebSocketHandler().onTextMessage(this);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "ScxWebSocketRoute : onTextMessage \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
            }
        } else if (this.frame.isBinary()) {
            try {
                next.baseWebSocketHandler().onBinaryMessage(this);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "ScxWebSocketRoute : onBinaryMessage \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
            }
        }
    }
}

