/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.parameter_handler;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.reflect.ParameterInfo;
import cool.scx.common.util.AnnotationUtils;
import cool.scx.common.util.ObjectUtils;
import cool.scx.web.annotation.FromUpload;
import cool.scx.web.parameter_handler.ParameterHandler;
import cool.scx.web.parameter_handler.RequestInfo;
import cool.scx.web.parameter_handler.exception.RequiredParamEmptyException;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class FileUploadParameterHandler
implements ParameterHandler {
    private static FileUpload[] findFileUploadListByName(RoutingContext routingContext, String name) {
        List fileUploads = routingContext.fileUploads();
        return (FileUpload[])fileUploads.stream().filter(f -> name.equals(f.name())).toArray(FileUpload[]::new);
    }

    @Override
    public boolean canHandle(ParameterInfo parameter) {
        boolean isArray = parameter.type().isCollectionLikeType() || parameter.type().isArrayType();
        Class rawType = isArray ? parameter.type().getContentType().getRawClass() : parameter.type().getRawClass();
        return rawType == FileUpload.class;
    }

    @Override
    public Object handle(ParameterInfo parameter, RequestInfo requestInfo) throws RequiredParamEmptyException {
        FileUpload[] v;
        String name = parameter.name();
        boolean required = false;
        FromUpload fromUpload = parameter.parameter().getAnnotation(FromUpload.class);
        if (fromUpload != null) {
            String _value = AnnotationUtils.getAnnotationValue((String)fromUpload.value());
            if (_value != null) {
                name = _value;
            }
            required = fromUpload.required();
        }
        if ((v = FileUploadParameterHandler.findFileUploadListByName(requestInfo.routingContext(), name)).length == 0) {
            if (required) {
                throw new RequiredParamEmptyException("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a !!! \u53c2\u6570\u540d\u79f0 [" + name + "] , \u53c2\u6570\u6765\u6e90 [FromUpload] , \u53c2\u6570\u7c7b\u578b [" + String.valueOf(parameter.type()) + "]");
            }
            return null;
        }
        boolean isCollection = parameter.type().isCollectionLikeType();
        boolean isArray = parameter.type().isArrayType();
        if (isArray) {
            return v;
        }
        if (isCollection) {
            Collection list = (Collection)ObjectUtils.convertValue((Object)new Object[0], (JavaType)parameter.type());
            Collections.addAll(list, v);
            return list;
        }
        return v[0];
    }
}

