/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import cool.scx.common.reflect.MethodInfo;
import cool.scx.common.standard.HttpMethod;
import cool.scx.common.util.AnnotationUtils;
import cool.scx.common.util.CaseUtils;
import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.common.util.URIBuilder;
import cool.scx.web.RouteRegistrar;
import cool.scx.web.RouteState;
import cool.scx.web.ScxWeb;
import cool.scx.web.ScxWebHelper;
import cool.scx.web.annotation.ScxRoute;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public final class ScxRouteHandler
implements Handler<RoutingContext> {
    public final MethodInfo method;
    public final boolean isVoid;
    public final Object instance;
    public final Class<?> clazz;
    public final String originalUrl;
    public final HttpMethod[] httpMethods;
    public final String[] consumes;
    public final String[] produces;
    private final ScxWeb scxWeb;
    private final int order;
    private RouteState routeState;

    ScxRouteHandler(MethodInfo method, Object instance, ScxWeb scxWeb) {
        this.scxWeb = scxWeb;
        this.clazz = instance.getClass();
        this.method = method;
        this.method.setAccessible(true);
        this.isVoid = method.returnType().getRawClass() == Void.TYPE;
        this.instance = instance;
        ScxRoute clazzAnnotation = this.clazz.getAnnotation(ScxRoute.class);
        ScxRoute methodAnnotation = RouteRegistrar.findScxRouteOrThrow(method);
        this.originalUrl = this.initOriginalUrl(clazzAnnotation, methodAnnotation);
        this.consumes = ScxRouteHandler.distinct(methodAnnotation.consumes());
        this.produces = ScxRouteHandler.distinct(methodAnnotation.produces());
        this.httpMethods = ScxRouteHandler.distinct(methodAnnotation.methods());
        this.order = methodAnnotation.order();
    }

    private static HttpMethod[] distinct(HttpMethod[] methods) {
        return (HttpMethod[])Arrays.stream(methods).distinct().toArray(HttpMethod[]::new);
    }

    private static String[] distinct(String[] strings) {
        return (String[])Arrays.stream(strings).distinct().toArray(String[]::new);
    }

    private String initOriginalUrl(ScxRoute classAnnotation, ScxRoute methodAnnotation) {
        String value;
        String classUrl = "";
        String methodUrl = "";
        if (classAnnotation != null && !methodAnnotation.ignoreParentUrl() && (value = AnnotationUtils.getAnnotationValue((String)classAnnotation.value())) != null) {
            classUrl = value;
        }
        if ((value = AnnotationUtils.getAnnotationValue((String)methodAnnotation.value())) != null) {
            methodUrl = value;
        } else if (methodAnnotation.useNameAsUrl()) {
            methodUrl = CaseUtils.toKebab((String)this.method.name());
        }
        return URIBuilder.addSlashStart((String)URIBuilder.join((String[])new String[]{classUrl, methodUrl}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext context) {
        ScxWeb._routingContext(context);
        try {
            this.scxWeb.interceptor().preHandle(context, this);
            Object[] methodParameters = this.scxWeb.buildMethodParameters(this.method.parameters(), context);
            Object tempResult = this.method.method().invoke(this.instance, methodParameters);
            Object finalResult = this.scxWeb.interceptor().postHandle(context, this, tempResult);
            if (!this.isVoid && ScxWebHelper.responseCanUse(context)) {
                this.scxWeb.findReturnValueHandler(finalResult).handle(finalResult, context);
            }
        }
        catch (Throwable e) {
            Throwable exception = ScxExceptionHelper.getRootCause((Throwable)(e instanceof InvocationTargetException ? e.getCause() : e));
            this.scxWeb.findExceptionHandler(exception).handle(exception, context);
        }
        finally {
            ScxWeb._clearRoutingContext();
        }
    }

    void setRouteState(RouteState route) {
        this.routeState = route;
    }

    RouteState routeState() {
        return this.routeState;
    }

    public int order() {
        return this.order;
    }
}

