/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web.parameter_handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import cool.scx.common.standard.HttpFieldName;
import cool.scx.common.standard.MediaType;
import cool.scx.common.util.ObjectUtils;
import cool.scx.web.exception.BadRequestException;
import io.vertx.ext.web.RoutingContext;

public final class RequestInfo {
    private final RoutingContext routingContext;
    private final JsonNode body;
    private final ContentType contentType;

    public RequestInfo(RoutingContext ctx) {
        this.routingContext = ctx;
        this.contentType = RequestInfo.initContentType(ctx);
        this.body = RequestInfo.initBody(ctx, this.contentType);
    }

    public static JsonNode initBody(RoutingContext ctx, ContentType contentType) {
        String bodyAsString = ctx.body().asString();
        if (bodyAsString == null) {
            return null;
        }
        return switch (contentType.ordinal()) {
            case 1 -> RequestInfo.readJson(bodyAsString);
            case 2 -> RequestInfo.readXml(bodyAsString);
            default -> RequestInfo.tryReadOrTextNode(bodyAsString);
        };
    }

    public static JsonNode readJson(String jsonStr) {
        try {
            return ObjectUtils.jsonMapper().readTree(jsonStr);
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException(e);
        }
    }

    public static JsonNode readXml(String xmlStr) {
        try {
            return ObjectUtils.xmlMapper().readTree(xmlStr);
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException(e);
        }
    }

    public static JsonNode tryReadOrTextNode(String str) {
        try {
            return ObjectUtils.jsonMapper().readTree(str);
        }
        catch (Exception exception) {
            try {
                return ObjectUtils.xmlMapper().readTree(str);
            }
            catch (JsonProcessingException e) {
                return new TextNode(str);
            }
        }
    }

    public static ContentType initContentType(RoutingContext ctx) {
        String contentType = ctx.request().headers().get(HttpFieldName.CONTENT_TYPE.toString());
        if (contentType != null) {
            contentType = contentType.toLowerCase();
        }
        if (contentType == null) {
            return ContentType.NULL;
        }
        if (contentType.startsWith(MediaType.APPLICATION_JSON.toString())) {
            return ContentType.JSON;
        }
        if (contentType.startsWith(MediaType.APPLICATION_XML.toString())) {
            return ContentType.XML;
        }
        if (contentType.startsWith(MediaType.MULTIPART_FORM_DATA.toString()) || contentType.startsWith(MediaType.APPLICATION_X_WWW_FORM_URLENCODED.toString())) {
            return ContentType.FORM;
        }
        return ContentType.OTHER;
    }

    public JsonNode body() {
        return this.body;
    }

    public ContentType contentType() {
        return this.contentType;
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }

    public static enum ContentType {
        FORM,
        JSON,
        XML,
        OTHER,
        NULL;

    }
}

