/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.web;

import cool.scx.common.reflect.AccessModifier;
import cool.scx.common.reflect.MethodInfo;
import cool.scx.common.reflect.ReflectFactory;
import cool.scx.common.standard.HttpMethod;
import cool.scx.common.util.ClassUtils;
import cool.scx.common.util.MultiMap;
import cool.scx.web.RouteState;
import cool.scx.web.ScxRouteHandler;
import cool.scx.web.ScxWeb;
import cool.scx.web.ScxWebHelper;
import cool.scx.web.annotation.NoScxRoute;
import cool.scx.web.annotation.ScxRoute;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;

public final class RouteRegistrar {
    private static final System.Logger logger = System.getLogger(RouteRegistrar.class.getName());
    private static final Comparator<ScxRouteHandler> EXACT_PATH_COMPARATOR = Comparator.comparing(routeState -> routeState.routeState().getExactPathOrder());
    private static final Comparator<ScxRouteHandler> GROUPS_COMPARATOR = Comparator.comparing(routeState -> routeState.routeState().getGroupsOrder());
    private static final Comparator<ScxRouteHandler> ORDER_COMPARATOR = Comparator.comparing(ScxRouteHandler::order);
    private static final Pattern RE_TOKEN_SEARCH = Pattern.compile(":(\\w+)");
    private final ScxWeb scxWeb;

    public RouteRegistrar(ScxWeb scxWeb) {
        this.scxWeb = scxWeb;
    }

    private static List<ScxRouteHandler> initScxRouteHandlers(ScxWeb scxWeb, Object ... objects) {
        List<Object> filteredObjectList = RouteRegistrar.filterObject(objects);
        ArrayList<ScxRouteHandler> handlers = new ArrayList<ScxRouteHandler>();
        for (Object c : filteredObjectList) {
            List<MethodInfo> methods = RouteRegistrar.filterMethod(c);
            for (MethodInfo m : methods) {
                handlers.add(RouteRegistrar.createScxRouteHandler(m, c, scxWeb));
            }
        }
        return RouteRegistrar.sortedScxRouteHandlers(handlers);
    }

    private static List<ScxRouteHandler> sortedScxRouteHandlers(List<ScxRouteHandler> handlers) {
        List<ScxRouteHandler> list = RouteRegistrar.fillRouteState(handlers);
        return list.stream().sorted(ORDER_COMPARATOR.thenComparing(EXACT_PATH_COMPARATOR).thenComparing(GROUPS_COMPARATOR)).toList();
    }

    private static List<ScxRouteHandler> fillRouteState(List<ScxRouteHandler> list) {
        Router tempRouter = Router.router(null);
        return list.stream().peek(c -> c.setRouteState(RouteState.getRouteState(tempRouter.route(c.originalUrl)))).toList();
    }

    private static ScxRouteHandler createScxRouteHandler(MethodInfo m, Object bean, ScxWeb scxWeb) {
        return new ScxRouteHandler(m, bean, scxWeb);
    }

    private static List<Object> filterObject(Object ... objects) {
        return Arrays.stream(objects).filter(o -> RouteRegistrar.isRoute(o.getClass())).toList();
    }

    public static List<Class<?>> filterClass(List<Class<?>> classList) {
        return classList.stream().filter(RouteRegistrar::isRoute).toList();
    }

    private static List<MethodInfo> filterMethod(Object object) {
        return Arrays.stream(ReflectFactory.getClassInfo(object.getClass()).allMethods()).filter(m -> m.accessModifier() == AccessModifier.PUBLIC && RouteRegistrar.isRoute(m)).toList();
    }

    public static boolean isRoute(Class<?> c) {
        return (c.isAnnotationPresent(ScxRoute.class) || c.isAnnotationPresent(Controller.class)) && ClassUtils.isNormalClass(c);
    }

    public static boolean isRoute(MethodInfo m) {
        NoScxRoute noScxRoute = m.method().getAnnotation(NoScxRoute.class);
        if (noScxRoute != null) {
            return false;
        }
        ScxRoute s = RouteRegistrar.findScxRoute(m);
        return s != null;
    }

    public static ScxRoute findScxRoute(MethodInfo method) {
        Annotation[] annotations;
        for (Annotation a : annotations = method.allAnnotations()) {
            if (!(a instanceof ScxRoute)) continue;
            ScxRoute s = (ScxRoute)a;
            return s;
        }
        return null;
    }

    public static ScxRoute findScxRouteOrThrow(MethodInfo method) {
        ScxRoute scxRoute = RouteRegistrar.findScxRoute(method);
        if (scxRoute == null) {
            throw new NullPointerException();
        }
        return scxRoute;
    }

    private static void checkRouteExists(List<ScxRouteHandler> handlers) {
        MultiMap m = new MultiMap();
        for (ScxRouteHandler handler : handlers) {
            String key;
            String string = key = handler.routeState().pattern() != null ? handler.routeState().pattern().toString() : handler.routeState().path();
            if (handler.httpMethods.length == 0) {
                m.put((Object)new NormalPathInfo("*", key), (Object)handler);
                continue;
            }
            for (HttpMethod httpMethod : handler.httpMethods) {
                m.put((Object)new NormalPathInfo(httpMethod.name(), key), (Object)handler);
            }
        }
        Map map = m.toMultiValueMap();
        map.forEach((k, v) -> {
            if (v.size() > 1) {
                String content = v.stream().map(c -> "\t" + c.clazz.getName() + " : " + c.method.name()).collect(Collectors.joining(System.lineSeparator()));
                logger.log(System.Logger.Level.WARNING, "\u68c0\u6d4b\u5230\u91cd\u590d\u7684\u8def\u7531!!! {0} --> \"{1}\" , \u76f8\u5173 class \u53ca \u65b9\u6cd5 \u5982\u4e0b \u25bc" + System.lineSeparator() + "{2}", k.httpMethod(), RouteRegistrar.getPatternUrl(((ScxRouteHandler)v.get((int)0)).originalUrl), content);
            }
        });
    }

    private static String getPatternUrl(String path) {
        return RE_TOKEN_SEARCH.matcher(path).replaceAll("?");
    }

    public Router registerRoute(Router router, Object ... objects) {
        List<ScxRouteHandler> scxRouteHandlers = RouteRegistrar.initScxRouteHandlers(this.scxWeb, objects);
        RouteRegistrar.checkRouteExists(scxRouteHandlers);
        for (ScxRouteHandler c : scxRouteHandlers) {
            Route r = router.route(c.originalUrl);
            for (HttpMethod httpMethod : c.httpMethods) {
                r.method(ScxWebHelper.toVertxMethod(httpMethod));
            }
            for (String string : c.consumes) {
                r.consumes(string);
            }
            for (String string : c.produces) {
                r.produces(string);
            }
            r.handler((Handler)c);
        }
        return router;
    }

    private record NormalPathInfo(String httpMethod, String path) {
    }
}

